// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.MSDeployCore;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * Core resource properties.
 */
@Fluent
public final class MSDeployProperties extends MSDeployCore {
    /*
     * List of Add-On packages. Add-On packages implicitly enable the Do Not Delete MSDeploy rule.
     */
    private List<MSDeployCore> addOnPackages;

    /**
     * Creates an instance of MSDeployProperties class.
     */
    public MSDeployProperties() {
    }

    /**
     * Get the addOnPackages property: List of Add-On packages. Add-On packages implicitly enable the Do Not Delete
     * MSDeploy rule.
     * 
     * @return the addOnPackages value.
     */
    public List<MSDeployCore> addOnPackages() {
        return this.addOnPackages;
    }

    /**
     * Set the addOnPackages property: List of Add-On packages. Add-On packages implicitly enable the Do Not Delete
     * MSDeploy rule.
     * 
     * @param addOnPackages the addOnPackages value to set.
     * @return the MSDeployProperties object itself.
     */
    public MSDeployProperties withAddOnPackages(List<MSDeployCore> addOnPackages) {
        this.addOnPackages = addOnPackages;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MSDeployProperties withPackageUri(String packageUri) {
        super.withPackageUri(packageUri);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MSDeployProperties withConnectionString(String connectionString) {
        super.withConnectionString(connectionString);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MSDeployProperties withDbType(String dbType) {
        super.withDbType(dbType);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MSDeployProperties withSetParametersXmlFileUri(String setParametersXmlFileUri) {
        super.withSetParametersXmlFileUri(setParametersXmlFileUri);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MSDeployProperties withSetParameters(Map<String, String> setParameters) {
        super.withSetParameters(setParameters);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MSDeployProperties withSkipAppData(Boolean skipAppData) {
        super.withSkipAppData(skipAppData);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MSDeployProperties withAppOffline(Boolean appOffline) {
        super.withAppOffline(appOffline);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        if (addOnPackages() != null) {
            addOnPackages().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("packageUri", packageUri());
        jsonWriter.writeStringField("connectionString", connectionString());
        jsonWriter.writeStringField("dbType", dbType());
        jsonWriter.writeStringField("setParametersXmlFileUri", setParametersXmlFileUri());
        jsonWriter.writeMapField("setParameters", setParameters(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeBooleanField("skipAppData", skipAppData());
        jsonWriter.writeBooleanField("appOffline", appOffline());
        jsonWriter.writeArrayField("addOnPackages", this.addOnPackages, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MSDeployProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MSDeployProperties if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the MSDeployProperties.
     */
    public static MSDeployProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MSDeployProperties deserializedMSDeployProperties = new MSDeployProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("packageUri".equals(fieldName)) {
                    deserializedMSDeployProperties.withPackageUri(reader.getString());
                } else if ("connectionString".equals(fieldName)) {
                    deserializedMSDeployProperties.withConnectionString(reader.getString());
                } else if ("dbType".equals(fieldName)) {
                    deserializedMSDeployProperties.withDbType(reader.getString());
                } else if ("setParametersXmlFileUri".equals(fieldName)) {
                    deserializedMSDeployProperties.withSetParametersXmlFileUri(reader.getString());
                } else if ("setParameters".equals(fieldName)) {
                    Map<String, String> setParameters = reader.readMap(reader1 -> reader1.getString());
                    deserializedMSDeployProperties.withSetParameters(setParameters);
                } else if ("skipAppData".equals(fieldName)) {
                    deserializedMSDeployProperties.withSkipAppData(reader.getNullable(JsonReader::getBoolean));
                } else if ("appOffline".equals(fieldName)) {
                    deserializedMSDeployProperties.withAppOffline(reader.getNullable(JsonReader::getBoolean));
                } else if ("addOnPackages".equals(fieldName)) {
                    List<MSDeployCore> addOnPackages = reader.readArray(reader1 -> MSDeployCore.fromJson(reader1));
                    deserializedMSDeployProperties.addOnPackages = addOnPackages;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedMSDeployProperties;
        });
    }
}
