// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import java.io.IOException;

/**
 * Used for getting ResourceHealthCheck settings.
 */
@Fluent
public final class ResourceHealthMetadataInner extends ProxyOnlyResource {
    /*
     * ResourceHealthMetadata resource specific properties
     */
    private ResourceHealthMetadataProperties innerProperties;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of ResourceHealthMetadataInner class.
     */
    public ResourceHealthMetadataInner() {
    }

    /**
     * Get the innerProperties property: ResourceHealthMetadata resource specific properties.
     * 
     * @return the innerProperties value.
     */
    private ResourceHealthMetadataProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ResourceHealthMetadataInner withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    /**
     * Get the category property: The category that the resource matches in the RHC Policy File.
     * 
     * @return the category value.
     */
    public String category() {
        return this.innerProperties() == null ? null : this.innerProperties().category();
    }

    /**
     * Set the category property: The category that the resource matches in the RHC Policy File.
     * 
     * @param category the category value to set.
     * @return the ResourceHealthMetadataInner object itself.
     */
    public ResourceHealthMetadataInner withCategory(String category) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ResourceHealthMetadataProperties();
        }
        this.innerProperties().withCategory(category);
        return this;
    }

    /**
     * Get the signalAvailability property: Is there a health signal for the resource.
     * 
     * @return the signalAvailability value.
     */
    public Boolean signalAvailability() {
        return this.innerProperties() == null ? null : this.innerProperties().signalAvailability();
    }

    /**
     * Set the signalAvailability property: Is there a health signal for the resource.
     * 
     * @param signalAvailability the signalAvailability value to set.
     * @return the ResourceHealthMetadataInner object itself.
     */
    public ResourceHealthMetadataInner withSignalAvailability(Boolean signalAvailability) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ResourceHealthMetadataProperties();
        }
        this.innerProperties().withSignalAvailability(signalAvailability);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", kind());
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ResourceHealthMetadataInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ResourceHealthMetadataInner if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ResourceHealthMetadataInner.
     */
    public static ResourceHealthMetadataInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ResourceHealthMetadataInner deserializedResourceHealthMetadataInner = new ResourceHealthMetadataInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedResourceHealthMetadataInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedResourceHealthMetadataInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedResourceHealthMetadataInner.type = reader.getString();
                } else if ("kind".equals(fieldName)) {
                    deserializedResourceHealthMetadataInner.withKind(reader.getString());
                } else if ("properties".equals(fieldName)) {
                    deserializedResourceHealthMetadataInner.innerProperties
                        = ResourceHealthMetadataProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedResourceHealthMetadataInner;
        });
    }
}
