// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Mounting protocol to use for the storage account.
 */
public final class AzureStorageProtocol extends ExpandableStringEnum<AzureStorageProtocol> {
    /**
     * Static value Smb for AzureStorageProtocol.
     */
    public static final AzureStorageProtocol SMB = fromString("Smb");

    /**
     * Static value Http for AzureStorageProtocol.
     */
    public static final AzureStorageProtocol HTTP = fromString("Http");

    /**
     * Static value Nfs for AzureStorageProtocol.
     */
    public static final AzureStorageProtocol NFS = fromString("Nfs");

    /**
     * Creates a new instance of AzureStorageProtocol value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public AzureStorageProtocol() {
    }

    /**
     * Creates or finds a AzureStorageProtocol from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding AzureStorageProtocol.
     */
    public static AzureStorageProtocol fromString(String name) {
        return fromString(name, AzureStorageProtocol.class);
    }

    /**
     * Gets known AzureStorageProtocol values.
     * 
     * @return known AzureStorageProtocol values.
     */
    public static Collection<AzureStorageProtocol> values() {
        return values(AzureStorageProtocol.class);
    }
}
