// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

/**
 * Current DNS type.
 */
public enum DnsType {
    /**
     * Enum value AzureDns.
     */
    AZURE_DNS("AzureDns"),

    /**
     * Enum value DefaultDomainRegistrarDns.
     */
    DEFAULT_DOMAIN_REGISTRAR_DNS("DefaultDomainRegistrarDns");

    /**
     * The actual serialized value for a DnsType instance.
     */
    private final String value;

    DnsType(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a DnsType instance.
     * 
     * @param value the serialized value to parse.
     * @return the parsed DnsType object, or null if unable to parse.
     */
    public static DnsType fromString(String value) {
        if (value == null) {
            return null;
        }
        DnsType[] items = DnsType.values();
        for (DnsType item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String toString() {
        return this.value;
    }
}
