// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Description of the App Service plan scale options.
 */
@Fluent
public final class SkuCapacity implements JsonSerializable<SkuCapacity> {
    /*
     * Minimum number of workers for this App Service plan SKU.
     */
    private Integer minimum;

    /*
     * Maximum number of workers for this App Service plan SKU.
     */
    private Integer maximum;

    /*
     * Maximum number of Elastic workers for this App Service plan SKU.
     */
    private Integer elasticMaximum;

    /*
     * Default number of workers for this App Service plan SKU.
     */
    private Integer defaultProperty;

    /*
     * Available scale configurations for an App Service plan.
     */
    private String scaleType;

    /**
     * Creates an instance of SkuCapacity class.
     */
    public SkuCapacity() {
    }

    /**
     * Get the minimum property: Minimum number of workers for this App Service plan SKU.
     * 
     * @return the minimum value.
     */
    public Integer minimum() {
        return this.minimum;
    }

    /**
     * Set the minimum property: Minimum number of workers for this App Service plan SKU.
     * 
     * @param minimum the minimum value to set.
     * @return the SkuCapacity object itself.
     */
    public SkuCapacity withMinimum(Integer minimum) {
        this.minimum = minimum;
        return this;
    }

    /**
     * Get the maximum property: Maximum number of workers for this App Service plan SKU.
     * 
     * @return the maximum value.
     */
    public Integer maximum() {
        return this.maximum;
    }

    /**
     * Set the maximum property: Maximum number of workers for this App Service plan SKU.
     * 
     * @param maximum the maximum value to set.
     * @return the SkuCapacity object itself.
     */
    public SkuCapacity withMaximum(Integer maximum) {
        this.maximum = maximum;
        return this;
    }

    /**
     * Get the elasticMaximum property: Maximum number of Elastic workers for this App Service plan SKU.
     * 
     * @return the elasticMaximum value.
     */
    public Integer elasticMaximum() {
        return this.elasticMaximum;
    }

    /**
     * Set the elasticMaximum property: Maximum number of Elastic workers for this App Service plan SKU.
     * 
     * @param elasticMaximum the elasticMaximum value to set.
     * @return the SkuCapacity object itself.
     */
    public SkuCapacity withElasticMaximum(Integer elasticMaximum) {
        this.elasticMaximum = elasticMaximum;
        return this;
    }

    /**
     * Get the defaultProperty property: Default number of workers for this App Service plan SKU.
     * 
     * @return the defaultProperty value.
     */
    public Integer defaultProperty() {
        return this.defaultProperty;
    }

    /**
     * Set the defaultProperty property: Default number of workers for this App Service plan SKU.
     * 
     * @param defaultProperty the defaultProperty value to set.
     * @return the SkuCapacity object itself.
     */
    public SkuCapacity withDefaultProperty(Integer defaultProperty) {
        this.defaultProperty = defaultProperty;
        return this;
    }

    /**
     * Get the scaleType property: Available scale configurations for an App Service plan.
     * 
     * @return the scaleType value.
     */
    public String scaleType() {
        return this.scaleType;
    }

    /**
     * Set the scaleType property: Available scale configurations for an App Service plan.
     * 
     * @param scaleType the scaleType value to set.
     * @return the SkuCapacity object itself.
     */
    public SkuCapacity withScaleType(String scaleType) {
        this.scaleType = scaleType;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("minimum", this.minimum);
        jsonWriter.writeNumberField("maximum", this.maximum);
        jsonWriter.writeNumberField("elasticMaximum", this.elasticMaximum);
        jsonWriter.writeNumberField("default", this.defaultProperty);
        jsonWriter.writeStringField("scaleType", this.scaleType);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SkuCapacity from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SkuCapacity if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the SkuCapacity.
     */
    public static SkuCapacity fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SkuCapacity deserializedSkuCapacity = new SkuCapacity();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("minimum".equals(fieldName)) {
                    deserializedSkuCapacity.minimum = reader.getNullable(JsonReader::getInt);
                } else if ("maximum".equals(fieldName)) {
                    deserializedSkuCapacity.maximum = reader.getNullable(JsonReader::getInt);
                } else if ("elasticMaximum".equals(fieldName)) {
                    deserializedSkuCapacity.elasticMaximum = reader.getNullable(JsonReader::getInt);
                } else if ("default".equals(fieldName)) {
                    deserializedSkuCapacity.defaultProperty = reader.getNullable(JsonReader::getInt);
                } else if ("scaleType".equals(fieldName)) {
                    deserializedSkuCapacity.scaleType = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSkuCapacity;
        });
    }
}
