/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.fluent.models.CapabilityInner;
import com.azure.resourcemanager.appservice.models.SkuCapacity;
import java.io.IOException;
import java.util.List;

public final class SkuDescription
implements JsonSerializable<SkuDescription> {
    private String name;
    private String tier;
    private String size;
    private String family;
    private Integer capacity;
    private SkuCapacity skuCapacity;
    private List<String> locations;
    private List<CapabilityInner> capabilities;

    public String name() {
        return this.name;
    }

    public SkuDescription withName(String name) {
        this.name = name;
        return this;
    }

    public String tier() {
        return this.tier;
    }

    public SkuDescription withTier(String tier) {
        this.tier = tier;
        return this;
    }

    public String size() {
        return this.size;
    }

    public SkuDescription withSize(String size) {
        this.size = size;
        return this;
    }

    public String family() {
        return this.family;
    }

    public SkuDescription withFamily(String family) {
        this.family = family;
        return this;
    }

    public Integer capacity() {
        return this.capacity;
    }

    public SkuDescription withCapacity(Integer capacity) {
        this.capacity = capacity;
        return this;
    }

    public SkuCapacity skuCapacity() {
        return this.skuCapacity;
    }

    public SkuDescription withSkuCapacity(SkuCapacity skuCapacity) {
        this.skuCapacity = skuCapacity;
        return this;
    }

    public List<String> locations() {
        return this.locations;
    }

    public SkuDescription withLocations(List<String> locations) {
        this.locations = locations;
        return this;
    }

    public List<CapabilityInner> capabilities() {
        return this.capabilities;
    }

    public SkuDescription withCapabilities(List<CapabilityInner> capabilities) {
        this.capabilities = capabilities;
        return this;
    }

    public void validate() {
        if (this.skuCapacity() != null) {
            this.skuCapacity().validate();
        }
        if (this.capabilities() != null) {
            this.capabilities().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("tier", this.tier);
        jsonWriter.writeStringField("size", this.size);
        jsonWriter.writeStringField("family", this.family);
        jsonWriter.writeNumberField("capacity", (Number)this.capacity);
        jsonWriter.writeJsonField("skuCapacity", (JsonSerializable)this.skuCapacity);
        jsonWriter.writeArrayField("locations", this.locations, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("capabilities", this.capabilities, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static SkuDescription fromJson(JsonReader jsonReader) throws IOException {
        return (SkuDescription)jsonReader.readObject(reader -> {
            SkuDescription deserializedSkuDescription = new SkuDescription();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedSkuDescription.name = reader.getString();
                    continue;
                }
                if ("tier".equals(fieldName)) {
                    deserializedSkuDescription.tier = reader.getString();
                    continue;
                }
                if ("size".equals(fieldName)) {
                    deserializedSkuDescription.size = reader.getString();
                    continue;
                }
                if ("family".equals(fieldName)) {
                    deserializedSkuDescription.family = reader.getString();
                    continue;
                }
                if ("capacity".equals(fieldName)) {
                    deserializedSkuDescription.capacity = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("skuCapacity".equals(fieldName)) {
                    deserializedSkuDescription.skuCapacity = SkuCapacity.fromJson(reader);
                    continue;
                }
                if ("locations".equals(fieldName)) {
                    List locations;
                    deserializedSkuDescription.locations = locations = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("capabilities".equals(fieldName)) {
                    List capabilities;
                    deserializedSkuDescription.capabilities = capabilities = reader.readArray(reader1 -> CapabilityInner.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSkuDescription;
        });
    }
}

