/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.ContinuousWebJobStatus;
import com.azure.resourcemanager.appservice.models.WebJobType;
import java.io.IOException;
import java.util.Map;

public final class ContinuousWebJobProperties
implements JsonSerializable<ContinuousWebJobProperties> {
    private ContinuousWebJobStatus status;
    private String detailedStatus;
    private String logUrl;
    private String runCommand;
    private String url;
    private String extraInfoUrl;
    private WebJobType webJobType;
    private String error;
    private Boolean usingSdk;
    private Map<String, Object> settings;

    public ContinuousWebJobStatus status() {
        return this.status;
    }

    public ContinuousWebJobProperties withStatus(ContinuousWebJobStatus status) {
        this.status = status;
        return this;
    }

    public String detailedStatus() {
        return this.detailedStatus;
    }

    public ContinuousWebJobProperties withDetailedStatus(String detailedStatus) {
        this.detailedStatus = detailedStatus;
        return this;
    }

    public String logUrl() {
        return this.logUrl;
    }

    public ContinuousWebJobProperties withLogUrl(String logUrl) {
        this.logUrl = logUrl;
        return this;
    }

    public String runCommand() {
        return this.runCommand;
    }

    public ContinuousWebJobProperties withRunCommand(String runCommand) {
        this.runCommand = runCommand;
        return this;
    }

    public String url() {
        return this.url;
    }

    public ContinuousWebJobProperties withUrl(String url) {
        this.url = url;
        return this;
    }

    public String extraInfoUrl() {
        return this.extraInfoUrl;
    }

    public ContinuousWebJobProperties withExtraInfoUrl(String extraInfoUrl) {
        this.extraInfoUrl = extraInfoUrl;
        return this;
    }

    public WebJobType webJobType() {
        return this.webJobType;
    }

    public ContinuousWebJobProperties withWebJobType(WebJobType webJobType) {
        this.webJobType = webJobType;
        return this;
    }

    public String error() {
        return this.error;
    }

    public ContinuousWebJobProperties withError(String error) {
        this.error = error;
        return this;
    }

    public Boolean usingSdk() {
        return this.usingSdk;
    }

    public ContinuousWebJobProperties withUsingSdk(Boolean usingSdk) {
        this.usingSdk = usingSdk;
        return this;
    }

    public Map<String, Object> settings() {
        return this.settings;
    }

    public ContinuousWebJobProperties withSettings(Map<String, Object> settings) {
        this.settings = settings;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeStringField("detailed_status", this.detailedStatus);
        jsonWriter.writeStringField("log_url", this.logUrl);
        jsonWriter.writeStringField("run_command", this.runCommand);
        jsonWriter.writeStringField("url", this.url);
        jsonWriter.writeStringField("extra_info_url", this.extraInfoUrl);
        jsonWriter.writeStringField("web_job_type", this.webJobType == null ? null : this.webJobType.toString());
        jsonWriter.writeStringField("error", this.error);
        jsonWriter.writeBooleanField("using_sdk", this.usingSdk);
        jsonWriter.writeMapField("settings", this.settings, (writer, element) -> writer.writeUntyped(element));
        return jsonWriter.writeEndObject();
    }

    public static ContinuousWebJobProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ContinuousWebJobProperties)jsonReader.readObject(reader -> {
            ContinuousWebJobProperties deserializedContinuousWebJobProperties = new ContinuousWebJobProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("status".equals(fieldName)) {
                    deserializedContinuousWebJobProperties.status = ContinuousWebJobStatus.fromString(reader.getString());
                    continue;
                }
                if ("detailed_status".equals(fieldName)) {
                    deserializedContinuousWebJobProperties.detailedStatus = reader.getString();
                    continue;
                }
                if ("log_url".equals(fieldName)) {
                    deserializedContinuousWebJobProperties.logUrl = reader.getString();
                    continue;
                }
                if ("run_command".equals(fieldName)) {
                    deserializedContinuousWebJobProperties.runCommand = reader.getString();
                    continue;
                }
                if ("url".equals(fieldName)) {
                    deserializedContinuousWebJobProperties.url = reader.getString();
                    continue;
                }
                if ("extra_info_url".equals(fieldName)) {
                    deserializedContinuousWebJobProperties.extraInfoUrl = reader.getString();
                    continue;
                }
                if ("web_job_type".equals(fieldName)) {
                    deserializedContinuousWebJobProperties.webJobType = WebJobType.fromString(reader.getString());
                    continue;
                }
                if ("error".equals(fieldName)) {
                    deserializedContinuousWebJobProperties.error = reader.getString();
                    continue;
                }
                if ("using_sdk".equals(fieldName)) {
                    deserializedContinuousWebJobProperties.usingSdk = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("settings".equals(fieldName)) {
                    Map settings;
                    deserializedContinuousWebJobProperties.settings = settings = reader.readMap(reader1 -> reader1.readUntyped());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedContinuousWebJobProperties;
        });
    }
}

