/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.CheckNameResourceTypes;
import java.io.IOException;

public final class DnlResourceNameAvailabilityRequest
implements JsonSerializable<DnlResourceNameAvailabilityRequest> {
    private String resourceGroupName;
    private String autoGeneratedDomainNameLabelScope;
    private String name;
    private CheckNameResourceTypes type;
    private static final ClientLogger LOGGER = new ClientLogger(DnlResourceNameAvailabilityRequest.class);

    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    public DnlResourceNameAvailabilityRequest withResourceGroupName(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    public String autoGeneratedDomainNameLabelScope() {
        return this.autoGeneratedDomainNameLabelScope;
    }

    public DnlResourceNameAvailabilityRequest withAutoGeneratedDomainNameLabelScope(String autoGeneratedDomainNameLabelScope) {
        this.autoGeneratedDomainNameLabelScope = autoGeneratedDomainNameLabelScope;
        return this;
    }

    public String name() {
        return this.name;
    }

    public DnlResourceNameAvailabilityRequest withName(String name) {
        this.name = name;
        return this;
    }

    public CheckNameResourceTypes type() {
        return this.type;
    }

    public DnlResourceNameAvailabilityRequest withType(CheckNameResourceTypes type) {
        this.type = type;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model DnlResourceNameAvailabilityRequest"));
        }
        if (this.type() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property type in model DnlResourceNameAvailabilityRequest"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("resourceGroupName", this.resourceGroupName);
        jsonWriter.writeStringField("autoGeneratedDomainNameLabelScope", this.autoGeneratedDomainNameLabelScope);
        return jsonWriter.writeEndObject();
    }

    public static DnlResourceNameAvailabilityRequest fromJson(JsonReader jsonReader) throws IOException {
        return (DnlResourceNameAvailabilityRequest)jsonReader.readObject(reader -> {
            DnlResourceNameAvailabilityRequest deserializedDnlResourceNameAvailabilityRequest = new DnlResourceNameAvailabilityRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedDnlResourceNameAvailabilityRequest.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedDnlResourceNameAvailabilityRequest.type = CheckNameResourceTypes.fromString(reader.getString());
                    continue;
                }
                if ("resourceGroupName".equals(fieldName)) {
                    deserializedDnlResourceNameAvailabilityRequest.resourceGroupName = reader.getString();
                    continue;
                }
                if ("autoGeneratedDomainNameLabelScope".equals(fieldName)) {
                    deserializedDnlResourceNameAvailabilityRequest.autoGeneratedDomainNameLabelScope = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDnlResourceNameAvailabilityRequest;
        });
    }
}

