// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import com.azure.resourcemanager.appservice.models.StackMajorVersion;
import java.io.IOException;
import java.util.List;

/**
 * ARM resource for a ApplicationStack.
 */
@Fluent
public final class ApplicationStackResourceInner extends ProxyOnlyResource {
    /*
     * Core resource properties
     */
    private ApplicationStack innerProperties;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of ApplicationStackResourceInner class.
     */
    public ApplicationStackResourceInner() {
    }

    /**
     * Get the innerProperties property: Core resource properties.
     * 
     * @return the innerProperties value.
     */
    private ApplicationStack innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ApplicationStackResourceInner withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    /**
     * Get the name property: Application stack name.
     * 
     * @return the name value.
     */
    public String namePropertiesName() {
        return this.innerProperties() == null ? null : this.innerProperties().name();
    }

    /**
     * Set the name property: Application stack name.
     * 
     * @param name the name value to set.
     * @return the ApplicationStackResourceInner object itself.
     */
    public ApplicationStackResourceInner withNamePropertiesName(String name) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationStack();
        }
        this.innerProperties().withName(name);
        return this;
    }

    /**
     * Get the display property: Application stack display name.
     * 
     * @return the display value.
     */
    public String display() {
        return this.innerProperties() == null ? null : this.innerProperties().display();
    }

    /**
     * Set the display property: Application stack display name.
     * 
     * @param display the display value to set.
     * @return the ApplicationStackResourceInner object itself.
     */
    public ApplicationStackResourceInner withDisplay(String display) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationStack();
        }
        this.innerProperties().withDisplay(display);
        return this;
    }

    /**
     * Get the dependency property: Application stack dependency.
     * 
     * @return the dependency value.
     */
    public String dependency() {
        return this.innerProperties() == null ? null : this.innerProperties().dependency();
    }

    /**
     * Set the dependency property: Application stack dependency.
     * 
     * @param dependency the dependency value to set.
     * @return the ApplicationStackResourceInner object itself.
     */
    public ApplicationStackResourceInner withDependency(String dependency) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationStack();
        }
        this.innerProperties().withDependency(dependency);
        return this;
    }

    /**
     * Get the majorVersions property: List of major versions available.
     * 
     * @return the majorVersions value.
     */
    public List<StackMajorVersion> majorVersions() {
        return this.innerProperties() == null ? null : this.innerProperties().majorVersions();
    }

    /**
     * Set the majorVersions property: List of major versions available.
     * 
     * @param majorVersions the majorVersions value to set.
     * @return the ApplicationStackResourceInner object itself.
     */
    public ApplicationStackResourceInner withMajorVersions(List<StackMajorVersion> majorVersions) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationStack();
        }
        this.innerProperties().withMajorVersions(majorVersions);
        return this;
    }

    /**
     * Get the frameworks property: List of frameworks associated with application stack.
     * 
     * @return the frameworks value.
     */
    public List<ApplicationStack> frameworks() {
        return this.innerProperties() == null ? null : this.innerProperties().frameworks();
    }

    /**
     * Set the frameworks property: List of frameworks associated with application stack.
     * 
     * @param frameworks the frameworks value to set.
     * @return the ApplicationStackResourceInner object itself.
     */
    public ApplicationStackResourceInner withFrameworks(List<ApplicationStack> frameworks) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationStack();
        }
        this.innerProperties().withFrameworks(frameworks);
        return this;
    }

    /**
     * Get the isDeprecated property: &lt;code&gt;true&lt;/code&gt; if this is the stack is deprecated; otherwise,
     * &lt;code&gt;false&lt;/code&gt;.
     * 
     * @return the isDeprecated value.
     */
    public List<ApplicationStack> isDeprecated() {
        return this.innerProperties() == null ? null : this.innerProperties().isDeprecated();
    }

    /**
     * Set the isDeprecated property: &lt;code&gt;true&lt;/code&gt; if this is the stack is deprecated; otherwise,
     * &lt;code&gt;false&lt;/code&gt;.
     * 
     * @param isDeprecated the isDeprecated value to set.
     * @return the ApplicationStackResourceInner object itself.
     */
    public ApplicationStackResourceInner withIsDeprecated(List<ApplicationStack> isDeprecated) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationStack();
        }
        this.innerProperties().withIsDeprecated(isDeprecated);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", kind());
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ApplicationStackResourceInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ApplicationStackResourceInner if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ApplicationStackResourceInner.
     */
    public static ApplicationStackResourceInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ApplicationStackResourceInner deserializedApplicationStackResourceInner
                = new ApplicationStackResourceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedApplicationStackResourceInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedApplicationStackResourceInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedApplicationStackResourceInner.type = reader.getString();
                } else if ("kind".equals(fieldName)) {
                    deserializedApplicationStackResourceInner.withKind(reader.getString());
                } else if ("properties".equals(fieldName)) {
                    deserializedApplicationStackResourceInner.innerProperties = ApplicationStack.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedApplicationStackResourceInner;
        });
    }
}
