// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.CustomDnsSuffixProvisioningState;
import java.io.IOException;

/**
 * CustomDnsSuffixConfiguration resource specific properties.
 */
@Fluent
public final class CustomDnsSuffixConfigurationProperties
    implements JsonSerializable<CustomDnsSuffixConfigurationProperties> {
    /*
     * The provisioningState property.
     */
    private CustomDnsSuffixProvisioningState provisioningState;

    /*
     * The provisioningDetails property.
     */
    private String provisioningDetails;

    /*
     * The default custom domain suffix to use for all sites deployed on the ASE.
     */
    private String dnsSuffix;

    /*
     * The URL referencing the Azure Key Vault certificate secret that should be used as the default SSL/TLS certificate
     * for sites with the custom domain suffix.
     */
    private String certificateUrl;

    /*
     * The user-assigned identity to use for resolving the key vault certificate reference. If not specified, the
     * system-assigned ASE identity will be used if available.
     */
    private String keyVaultReferenceIdentity;

    /**
     * Creates an instance of CustomDnsSuffixConfigurationProperties class.
     */
    public CustomDnsSuffixConfigurationProperties() {
    }

    /**
     * Get the provisioningState property: The provisioningState property.
     * 
     * @return the provisioningState value.
     */
    public CustomDnsSuffixProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the provisioningDetails property: The provisioningDetails property.
     * 
     * @return the provisioningDetails value.
     */
    public String provisioningDetails() {
        return this.provisioningDetails;
    }

    /**
     * Get the dnsSuffix property: The default custom domain suffix to use for all sites deployed on the ASE.
     * 
     * @return the dnsSuffix value.
     */
    public String dnsSuffix() {
        return this.dnsSuffix;
    }

    /**
     * Set the dnsSuffix property: The default custom domain suffix to use for all sites deployed on the ASE.
     * 
     * @param dnsSuffix the dnsSuffix value to set.
     * @return the CustomDnsSuffixConfigurationProperties object itself.
     */
    public CustomDnsSuffixConfigurationProperties withDnsSuffix(String dnsSuffix) {
        this.dnsSuffix = dnsSuffix;
        return this;
    }

    /**
     * Get the certificateUrl property: The URL referencing the Azure Key Vault certificate secret that should be used
     * as the default SSL/TLS certificate for sites with the custom domain suffix.
     * 
     * @return the certificateUrl value.
     */
    public String certificateUrl() {
        return this.certificateUrl;
    }

    /**
     * Set the certificateUrl property: The URL referencing the Azure Key Vault certificate secret that should be used
     * as the default SSL/TLS certificate for sites with the custom domain suffix.
     * 
     * @param certificateUrl the certificateUrl value to set.
     * @return the CustomDnsSuffixConfigurationProperties object itself.
     */
    public CustomDnsSuffixConfigurationProperties withCertificateUrl(String certificateUrl) {
        this.certificateUrl = certificateUrl;
        return this;
    }

    /**
     * Get the keyVaultReferenceIdentity property: The user-assigned identity to use for resolving the key vault
     * certificate reference. If not specified, the system-assigned ASE identity will be used if available.
     * 
     * @return the keyVaultReferenceIdentity value.
     */
    public String keyVaultReferenceIdentity() {
        return this.keyVaultReferenceIdentity;
    }

    /**
     * Set the keyVaultReferenceIdentity property: The user-assigned identity to use for resolving the key vault
     * certificate reference. If not specified, the system-assigned ASE identity will be used if available.
     * 
     * @param keyVaultReferenceIdentity the keyVaultReferenceIdentity value to set.
     * @return the CustomDnsSuffixConfigurationProperties object itself.
     */
    public CustomDnsSuffixConfigurationProperties withKeyVaultReferenceIdentity(String keyVaultReferenceIdentity) {
        this.keyVaultReferenceIdentity = keyVaultReferenceIdentity;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("dnsSuffix", this.dnsSuffix);
        jsonWriter.writeStringField("certificateUrl", this.certificateUrl);
        jsonWriter.writeStringField("keyVaultReferenceIdentity", this.keyVaultReferenceIdentity);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CustomDnsSuffixConfigurationProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CustomDnsSuffixConfigurationProperties if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the CustomDnsSuffixConfigurationProperties.
     */
    public static CustomDnsSuffixConfigurationProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CustomDnsSuffixConfigurationProperties deserializedCustomDnsSuffixConfigurationProperties
                = new CustomDnsSuffixConfigurationProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("provisioningState".equals(fieldName)) {
                    deserializedCustomDnsSuffixConfigurationProperties.provisioningState
                        = CustomDnsSuffixProvisioningState.fromString(reader.getString());
                } else if ("provisioningDetails".equals(fieldName)) {
                    deserializedCustomDnsSuffixConfigurationProperties.provisioningDetails = reader.getString();
                } else if ("dnsSuffix".equals(fieldName)) {
                    deserializedCustomDnsSuffixConfigurationProperties.dnsSuffix = reader.getString();
                } else if ("certificateUrl".equals(fieldName)) {
                    deserializedCustomDnsSuffixConfigurationProperties.certificateUrl = reader.getString();
                } else if ("keyVaultReferenceIdentity".equals(fieldName)) {
                    deserializedCustomDnsSuffixConfigurationProperties.keyVaultReferenceIdentity = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCustomDnsSuffixConfigurationProperties;
        });
    }
}
