// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.DnsVerificationTestResult;
import com.azure.resourcemanager.appservice.models.ErrorEntity;
import java.io.IOException;
import java.util.List;

/**
 * CustomHostnameAnalysisResult resource specific properties.
 */
@Fluent
public final class CustomHostnameAnalysisResultProperties
    implements JsonSerializable<CustomHostnameAnalysisResultProperties> {
    /*
     * <code>true</code> if hostname is already verified; otherwise, <code>false</code>.
     */
    private Boolean isHostnameAlreadyVerified;

    /*
     * DNS verification test result.
     */
    private DnsVerificationTestResult customDomainVerificationTest;

    /*
     * Raw failure information if DNS verification fails.
     */
    private ErrorEntity customDomainVerificationFailureInfo;

    /*
     * <code>true</code> if there is a conflict on a scale unit; otherwise, <code>false</code>.
     */
    private Boolean hasConflictOnScaleUnit;

    /*
     * <code>true</code> if there is a conflict across subscriptions; otherwise, <code>false</code>.
     */
    private Boolean hasConflictAcrossSubscription;

    /*
     * Name of the conflicting app on scale unit if it's within the same subscription.
     */
    private String conflictingAppResourceId;

    /*
     * CName records controller can see for this hostname.
     */
    private List<String> cNameRecords;

    /*
     * TXT records controller can see for this hostname.
     */
    private List<String> txtRecords;

    /*
     * A records controller can see for this hostname.
     */
    private List<String> aRecords;

    /*
     * Alternate CName records controller can see for this hostname.
     */
    private List<String> alternateCNameRecords;

    /*
     * Alternate TXT records controller can see for this hostname.
     */
    private List<String> alternateTxtRecords;

    /**
     * Creates an instance of CustomHostnameAnalysisResultProperties class.
     */
    public CustomHostnameAnalysisResultProperties() {
    }

    /**
     * Get the isHostnameAlreadyVerified property: &lt;code&gt;true&lt;/code&gt; if hostname is already verified;
     * otherwise, &lt;code&gt;false&lt;/code&gt;.
     * 
     * @return the isHostnameAlreadyVerified value.
     */
    public Boolean isHostnameAlreadyVerified() {
        return this.isHostnameAlreadyVerified;
    }

    /**
     * Get the customDomainVerificationTest property: DNS verification test result.
     * 
     * @return the customDomainVerificationTest value.
     */
    public DnsVerificationTestResult customDomainVerificationTest() {
        return this.customDomainVerificationTest;
    }

    /**
     * Get the customDomainVerificationFailureInfo property: Raw failure information if DNS verification fails.
     * 
     * @return the customDomainVerificationFailureInfo value.
     */
    public ErrorEntity customDomainVerificationFailureInfo() {
        return this.customDomainVerificationFailureInfo;
    }

    /**
     * Get the hasConflictOnScaleUnit property: &lt;code&gt;true&lt;/code&gt; if there is a conflict on a scale unit;
     * otherwise, &lt;code&gt;false&lt;/code&gt;.
     * 
     * @return the hasConflictOnScaleUnit value.
     */
    public Boolean hasConflictOnScaleUnit() {
        return this.hasConflictOnScaleUnit;
    }

    /**
     * Get the hasConflictAcrossSubscription property: &lt;code&gt;true&lt;/code&gt; if there is a conflict across
     * subscriptions; otherwise, &lt;code&gt;false&lt;/code&gt;.
     * 
     * @return the hasConflictAcrossSubscription value.
     */
    public Boolean hasConflictAcrossSubscription() {
        return this.hasConflictAcrossSubscription;
    }

    /**
     * Get the conflictingAppResourceId property: Name of the conflicting app on scale unit if it's within the same
     * subscription.
     * 
     * @return the conflictingAppResourceId value.
     */
    public String conflictingAppResourceId() {
        return this.conflictingAppResourceId;
    }

    /**
     * Get the cNameRecords property: CName records controller can see for this hostname.
     * 
     * @return the cNameRecords value.
     */
    public List<String> cNameRecords() {
        return this.cNameRecords;
    }

    /**
     * Set the cNameRecords property: CName records controller can see for this hostname.
     * 
     * @param cNameRecords the cNameRecords value to set.
     * @return the CustomHostnameAnalysisResultProperties object itself.
     */
    public CustomHostnameAnalysisResultProperties withCNameRecords(List<String> cNameRecords) {
        this.cNameRecords = cNameRecords;
        return this;
    }

    /**
     * Get the txtRecords property: TXT records controller can see for this hostname.
     * 
     * @return the txtRecords value.
     */
    public List<String> txtRecords() {
        return this.txtRecords;
    }

    /**
     * Set the txtRecords property: TXT records controller can see for this hostname.
     * 
     * @param txtRecords the txtRecords value to set.
     * @return the CustomHostnameAnalysisResultProperties object itself.
     */
    public CustomHostnameAnalysisResultProperties withTxtRecords(List<String> txtRecords) {
        this.txtRecords = txtRecords;
        return this;
    }

    /**
     * Get the aRecords property: A records controller can see for this hostname.
     * 
     * @return the aRecords value.
     */
    public List<String> aRecords() {
        return this.aRecords;
    }

    /**
     * Set the aRecords property: A records controller can see for this hostname.
     * 
     * @param aRecords the aRecords value to set.
     * @return the CustomHostnameAnalysisResultProperties object itself.
     */
    public CustomHostnameAnalysisResultProperties withARecords(List<String> aRecords) {
        this.aRecords = aRecords;
        return this;
    }

    /**
     * Get the alternateCNameRecords property: Alternate CName records controller can see for this hostname.
     * 
     * @return the alternateCNameRecords value.
     */
    public List<String> alternateCNameRecords() {
        return this.alternateCNameRecords;
    }

    /**
     * Set the alternateCNameRecords property: Alternate CName records controller can see for this hostname.
     * 
     * @param alternateCNameRecords the alternateCNameRecords value to set.
     * @return the CustomHostnameAnalysisResultProperties object itself.
     */
    public CustomHostnameAnalysisResultProperties withAlternateCNameRecords(List<String> alternateCNameRecords) {
        this.alternateCNameRecords = alternateCNameRecords;
        return this;
    }

    /**
     * Get the alternateTxtRecords property: Alternate TXT records controller can see for this hostname.
     * 
     * @return the alternateTxtRecords value.
     */
    public List<String> alternateTxtRecords() {
        return this.alternateTxtRecords;
    }

    /**
     * Set the alternateTxtRecords property: Alternate TXT records controller can see for this hostname.
     * 
     * @param alternateTxtRecords the alternateTxtRecords value to set.
     * @return the CustomHostnameAnalysisResultProperties object itself.
     */
    public CustomHostnameAnalysisResultProperties withAlternateTxtRecords(List<String> alternateTxtRecords) {
        this.alternateTxtRecords = alternateTxtRecords;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (customDomainVerificationFailureInfo() != null) {
            customDomainVerificationFailureInfo().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("cNameRecords", this.cNameRecords, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("txtRecords", this.txtRecords, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("aRecords", this.aRecords, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("alternateCNameRecords", this.alternateCNameRecords,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("alternateTxtRecords", this.alternateTxtRecords,
            (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CustomHostnameAnalysisResultProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CustomHostnameAnalysisResultProperties if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the CustomHostnameAnalysisResultProperties.
     */
    public static CustomHostnameAnalysisResultProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CustomHostnameAnalysisResultProperties deserializedCustomHostnameAnalysisResultProperties
                = new CustomHostnameAnalysisResultProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("isHostnameAlreadyVerified".equals(fieldName)) {
                    deserializedCustomHostnameAnalysisResultProperties.isHostnameAlreadyVerified
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("customDomainVerificationTest".equals(fieldName)) {
                    deserializedCustomHostnameAnalysisResultProperties.customDomainVerificationTest
                        = DnsVerificationTestResult.fromString(reader.getString());
                } else if ("customDomainVerificationFailureInfo".equals(fieldName)) {
                    deserializedCustomHostnameAnalysisResultProperties.customDomainVerificationFailureInfo
                        = ErrorEntity.fromJson(reader);
                } else if ("hasConflictOnScaleUnit".equals(fieldName)) {
                    deserializedCustomHostnameAnalysisResultProperties.hasConflictOnScaleUnit
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("hasConflictAcrossSubscription".equals(fieldName)) {
                    deserializedCustomHostnameAnalysisResultProperties.hasConflictAcrossSubscription
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("conflictingAppResourceId".equals(fieldName)) {
                    deserializedCustomHostnameAnalysisResultProperties.conflictingAppResourceId = reader.getString();
                } else if ("cNameRecords".equals(fieldName)) {
                    List<String> cNameRecords = reader.readArray(reader1 -> reader1.getString());
                    deserializedCustomHostnameAnalysisResultProperties.cNameRecords = cNameRecords;
                } else if ("txtRecords".equals(fieldName)) {
                    List<String> txtRecords = reader.readArray(reader1 -> reader1.getString());
                    deserializedCustomHostnameAnalysisResultProperties.txtRecords = txtRecords;
                } else if ("aRecords".equals(fieldName)) {
                    List<String> aRecords = reader.readArray(reader1 -> reader1.getString());
                    deserializedCustomHostnameAnalysisResultProperties.aRecords = aRecords;
                } else if ("alternateCNameRecords".equals(fieldName)) {
                    List<String> alternateCNameRecords = reader.readArray(reader1 -> reader1.getString());
                    deserializedCustomHostnameAnalysisResultProperties.alternateCNameRecords = alternateCNameRecords;
                } else if ("alternateTxtRecords".equals(fieldName)) {
                    List<String> alternateTxtRecords = reader.readArray(reader1 -> reader1.getString());
                    deserializedCustomHostnameAnalysisResultProperties.alternateTxtRecords = alternateTxtRecords;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCustomHostnameAnalysisResultProperties;
        });
    }
}
