// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import java.io.IOException;
import java.time.OffsetDateTime;

/**
 * Process Thread Information.
 */
@Fluent
public final class ProcessThreadInfoInner extends ProxyOnlyResource {
    /*
     * ProcessThreadInfo resource specific properties
     */
    private ProcessThreadInfoProperties innerProperties;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of ProcessThreadInfoInner class.
     */
    public ProcessThreadInfoInner() {
    }

    /**
     * Get the innerProperties property: ProcessThreadInfo resource specific properties.
     * 
     * @return the innerProperties value.
     */
    private ProcessThreadInfoProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ProcessThreadInfoInner withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    /**
     * Get the identifier property: Site extension ID.
     * 
     * @return the identifier value.
     */
    public Integer identifier() {
        return this.innerProperties() == null ? null : this.innerProperties().identifier();
    }

    /**
     * Get the href property: HRef URI.
     * 
     * @return the href value.
     */
    public String href() {
        return this.innerProperties() == null ? null : this.innerProperties().href();
    }

    /**
     * Set the href property: HRef URI.
     * 
     * @param href the href value to set.
     * @return the ProcessThreadInfoInner object itself.
     */
    public ProcessThreadInfoInner withHref(String href) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ProcessThreadInfoProperties();
        }
        this.innerProperties().withHref(href);
        return this;
    }

    /**
     * Get the process property: Process URI.
     * 
     * @return the process value.
     */
    public String process() {
        return this.innerProperties() == null ? null : this.innerProperties().process();
    }

    /**
     * Set the process property: Process URI.
     * 
     * @param process the process value to set.
     * @return the ProcessThreadInfoInner object itself.
     */
    public ProcessThreadInfoInner withProcess(String process) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ProcessThreadInfoProperties();
        }
        this.innerProperties().withProcess(process);
        return this;
    }

    /**
     * Get the startAddress property: Start address.
     * 
     * @return the startAddress value.
     */
    public String startAddress() {
        return this.innerProperties() == null ? null : this.innerProperties().startAddress();
    }

    /**
     * Set the startAddress property: Start address.
     * 
     * @param startAddress the startAddress value to set.
     * @return the ProcessThreadInfoInner object itself.
     */
    public ProcessThreadInfoInner withStartAddress(String startAddress) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ProcessThreadInfoProperties();
        }
        this.innerProperties().withStartAddress(startAddress);
        return this;
    }

    /**
     * Get the currentPriority property: Current thread priority.
     * 
     * @return the currentPriority value.
     */
    public Integer currentPriority() {
        return this.innerProperties() == null ? null : this.innerProperties().currentPriority();
    }

    /**
     * Set the currentPriority property: Current thread priority.
     * 
     * @param currentPriority the currentPriority value to set.
     * @return the ProcessThreadInfoInner object itself.
     */
    public ProcessThreadInfoInner withCurrentPriority(Integer currentPriority) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ProcessThreadInfoProperties();
        }
        this.innerProperties().withCurrentPriority(currentPriority);
        return this;
    }

    /**
     * Get the priorityLevel property: Thread priority level.
     * 
     * @return the priorityLevel value.
     */
    public String priorityLevel() {
        return this.innerProperties() == null ? null : this.innerProperties().priorityLevel();
    }

    /**
     * Set the priorityLevel property: Thread priority level.
     * 
     * @param priorityLevel the priorityLevel value to set.
     * @return the ProcessThreadInfoInner object itself.
     */
    public ProcessThreadInfoInner withPriorityLevel(String priorityLevel) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ProcessThreadInfoProperties();
        }
        this.innerProperties().withPriorityLevel(priorityLevel);
        return this;
    }

    /**
     * Get the basePriority property: Base priority.
     * 
     * @return the basePriority value.
     */
    public Integer basePriority() {
        return this.innerProperties() == null ? null : this.innerProperties().basePriority();
    }

    /**
     * Set the basePriority property: Base priority.
     * 
     * @param basePriority the basePriority value to set.
     * @return the ProcessThreadInfoInner object itself.
     */
    public ProcessThreadInfoInner withBasePriority(Integer basePriority) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ProcessThreadInfoProperties();
        }
        this.innerProperties().withBasePriority(basePriority);
        return this;
    }

    /**
     * Get the startTime property: Start time.
     * 
     * @return the startTime value.
     */
    public OffsetDateTime startTime() {
        return this.innerProperties() == null ? null : this.innerProperties().startTime();
    }

    /**
     * Set the startTime property: Start time.
     * 
     * @param startTime the startTime value to set.
     * @return the ProcessThreadInfoInner object itself.
     */
    public ProcessThreadInfoInner withStartTime(OffsetDateTime startTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ProcessThreadInfoProperties();
        }
        this.innerProperties().withStartTime(startTime);
        return this;
    }

    /**
     * Get the totalProcessorTime property: Total processor time.
     * 
     * @return the totalProcessorTime value.
     */
    public String totalProcessorTime() {
        return this.innerProperties() == null ? null : this.innerProperties().totalProcessorTime();
    }

    /**
     * Set the totalProcessorTime property: Total processor time.
     * 
     * @param totalProcessorTime the totalProcessorTime value to set.
     * @return the ProcessThreadInfoInner object itself.
     */
    public ProcessThreadInfoInner withTotalProcessorTime(String totalProcessorTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ProcessThreadInfoProperties();
        }
        this.innerProperties().withTotalProcessorTime(totalProcessorTime);
        return this;
    }

    /**
     * Get the userProcessorTime property: User processor time.
     * 
     * @return the userProcessorTime value.
     */
    public String userProcessorTime() {
        return this.innerProperties() == null ? null : this.innerProperties().userProcessorTime();
    }

    /**
     * Set the userProcessorTime property: User processor time.
     * 
     * @param userProcessorTime the userProcessorTime value to set.
     * @return the ProcessThreadInfoInner object itself.
     */
    public ProcessThreadInfoInner withUserProcessorTime(String userProcessorTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ProcessThreadInfoProperties();
        }
        this.innerProperties().withUserProcessorTime(userProcessorTime);
        return this;
    }

    /**
     * Get the state property: Thread state.
     * 
     * @return the state value.
     */
    public String state() {
        return this.innerProperties() == null ? null : this.innerProperties().state();
    }

    /**
     * Set the state property: Thread state.
     * 
     * @param state the state value to set.
     * @return the ProcessThreadInfoInner object itself.
     */
    public ProcessThreadInfoInner withState(String state) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ProcessThreadInfoProperties();
        }
        this.innerProperties().withState(state);
        return this;
    }

    /**
     * Get the waitReason property: Wait reason.
     * 
     * @return the waitReason value.
     */
    public String waitReason() {
        return this.innerProperties() == null ? null : this.innerProperties().waitReason();
    }

    /**
     * Set the waitReason property: Wait reason.
     * 
     * @param waitReason the waitReason value to set.
     * @return the ProcessThreadInfoInner object itself.
     */
    public ProcessThreadInfoInner withWaitReason(String waitReason) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ProcessThreadInfoProperties();
        }
        this.innerProperties().withWaitReason(waitReason);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", kind());
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ProcessThreadInfoInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ProcessThreadInfoInner if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ProcessThreadInfoInner.
     */
    public static ProcessThreadInfoInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ProcessThreadInfoInner deserializedProcessThreadInfoInner = new ProcessThreadInfoInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedProcessThreadInfoInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedProcessThreadInfoInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedProcessThreadInfoInner.type = reader.getString();
                } else if ("kind".equals(fieldName)) {
                    deserializedProcessThreadInfoInner.withKind(reader.getString());
                } else if ("properties".equals(fieldName)) {
                    deserializedProcessThreadInfoInner.innerProperties = ProcessThreadInfoProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedProcessThreadInfoInner;
        });
    }
}
