// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Names for connection strings, application settings, and external Azure storage account configuration
 * identifiers to be marked as sticky to the deployment slot and not moved during a swap operation.
 * This is valid for all deployment slots in an app.
 */
@Fluent
public final class SlotConfigNames implements JsonSerializable<SlotConfigNames> {
    /*
     * List of connection string names.
     */
    private List<String> connectionStringNames;

    /*
     * List of application settings names.
     */
    private List<String> appSettingNames;

    /*
     * List of external Azure storage account identifiers.
     */
    private List<String> azureStorageConfigNames;

    /**
     * Creates an instance of SlotConfigNames class.
     */
    public SlotConfigNames() {
    }

    /**
     * Get the connectionStringNames property: List of connection string names.
     * 
     * @return the connectionStringNames value.
     */
    public List<String> connectionStringNames() {
        return this.connectionStringNames;
    }

    /**
     * Set the connectionStringNames property: List of connection string names.
     * 
     * @param connectionStringNames the connectionStringNames value to set.
     * @return the SlotConfigNames object itself.
     */
    public SlotConfigNames withConnectionStringNames(List<String> connectionStringNames) {
        this.connectionStringNames = connectionStringNames;
        return this;
    }

    /**
     * Get the appSettingNames property: List of application settings names.
     * 
     * @return the appSettingNames value.
     */
    public List<String> appSettingNames() {
        return this.appSettingNames;
    }

    /**
     * Set the appSettingNames property: List of application settings names.
     * 
     * @param appSettingNames the appSettingNames value to set.
     * @return the SlotConfigNames object itself.
     */
    public SlotConfigNames withAppSettingNames(List<String> appSettingNames) {
        this.appSettingNames = appSettingNames;
        return this;
    }

    /**
     * Get the azureStorageConfigNames property: List of external Azure storage account identifiers.
     * 
     * @return the azureStorageConfigNames value.
     */
    public List<String> azureStorageConfigNames() {
        return this.azureStorageConfigNames;
    }

    /**
     * Set the azureStorageConfigNames property: List of external Azure storage account identifiers.
     * 
     * @param azureStorageConfigNames the azureStorageConfigNames value to set.
     * @return the SlotConfigNames object itself.
     */
    public SlotConfigNames withAzureStorageConfigNames(List<String> azureStorageConfigNames) {
        this.azureStorageConfigNames = azureStorageConfigNames;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("connectionStringNames", this.connectionStringNames,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("appSettingNames", this.appSettingNames,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("azureStorageConfigNames", this.azureStorageConfigNames,
            (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SlotConfigNames from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SlotConfigNames if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the SlotConfigNames.
     */
    public static SlotConfigNames fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SlotConfigNames deserializedSlotConfigNames = new SlotConfigNames();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("connectionStringNames".equals(fieldName)) {
                    List<String> connectionStringNames = reader.readArray(reader1 -> reader1.getString());
                    deserializedSlotConfigNames.connectionStringNames = connectionStringNames;
                } else if ("appSettingNames".equals(fieldName)) {
                    List<String> appSettingNames = reader.readArray(reader1 -> reader1.getString());
                    deserializedSlotConfigNames.appSettingNames = appSettingNames;
                } else if ("azureStorageConfigNames".equals(fieldName)) {
                    List<String> azureStorageConfigNames = reader.readArray(reader1 -> reader1.getString());
                    deserializedSlotConfigNames.azureStorageConfigNames = azureStorageConfigNames;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSlotConfigNames;
        });
    }
}
