// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

/**
 * Class representing Abnormal Time Period detected.
 */
@Fluent
public final class DetectorAbnormalTimePeriod implements JsonSerializable<DetectorAbnormalTimePeriod> {
    /*
     * Start time of the correlated event
     */
    private OffsetDateTime startTime;

    /*
     * End time of the correlated event
     */
    private OffsetDateTime endTime;

    /*
     * Message describing the event
     */
    private String message;

    /*
     * Represents the name of the Detector
     */
    private String source;

    /*
     * Represents the rank of the Detector
     */
    private Double priority;

    /*
     * Downtime metadata
     */
    private List<List<NameValuePair>> metadata;

    /*
     * Represents the type of the Detector
     */
    private IssueType type;

    /*
     * List of proposed solutions
     */
    private List<Solution> solutions;

    /**
     * Creates an instance of DetectorAbnormalTimePeriod class.
     */
    public DetectorAbnormalTimePeriod() {
    }

    /**
     * Get the startTime property: Start time of the correlated event.
     * 
     * @return the startTime value.
     */
    public OffsetDateTime startTime() {
        return this.startTime;
    }

    /**
     * Set the startTime property: Start time of the correlated event.
     * 
     * @param startTime the startTime value to set.
     * @return the DetectorAbnormalTimePeriod object itself.
     */
    public DetectorAbnormalTimePeriod withStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    /**
     * Get the endTime property: End time of the correlated event.
     * 
     * @return the endTime value.
     */
    public OffsetDateTime endTime() {
        return this.endTime;
    }

    /**
     * Set the endTime property: End time of the correlated event.
     * 
     * @param endTime the endTime value to set.
     * @return the DetectorAbnormalTimePeriod object itself.
     */
    public DetectorAbnormalTimePeriod withEndTime(OffsetDateTime endTime) {
        this.endTime = endTime;
        return this;
    }

    /**
     * Get the message property: Message describing the event.
     * 
     * @return the message value.
     */
    public String message() {
        return this.message;
    }

    /**
     * Set the message property: Message describing the event.
     * 
     * @param message the message value to set.
     * @return the DetectorAbnormalTimePeriod object itself.
     */
    public DetectorAbnormalTimePeriod withMessage(String message) {
        this.message = message;
        return this;
    }

    /**
     * Get the source property: Represents the name of the Detector.
     * 
     * @return the source value.
     */
    public String source() {
        return this.source;
    }

    /**
     * Set the source property: Represents the name of the Detector.
     * 
     * @param source the source value to set.
     * @return the DetectorAbnormalTimePeriod object itself.
     */
    public DetectorAbnormalTimePeriod withSource(String source) {
        this.source = source;
        return this;
    }

    /**
     * Get the priority property: Represents the rank of the Detector.
     * 
     * @return the priority value.
     */
    public Double priority() {
        return this.priority;
    }

    /**
     * Set the priority property: Represents the rank of the Detector.
     * 
     * @param priority the priority value to set.
     * @return the DetectorAbnormalTimePeriod object itself.
     */
    public DetectorAbnormalTimePeriod withPriority(Double priority) {
        this.priority = priority;
        return this;
    }

    /**
     * Get the metadata property: Downtime metadata.
     * 
     * @return the metadata value.
     */
    public List<List<NameValuePair>> metadata() {
        return this.metadata;
    }

    /**
     * Set the metadata property: Downtime metadata.
     * 
     * @param metadata the metadata value to set.
     * @return the DetectorAbnormalTimePeriod object itself.
     */
    public DetectorAbnormalTimePeriod withMetadata(List<List<NameValuePair>> metadata) {
        this.metadata = metadata;
        return this;
    }

    /**
     * Get the type property: Represents the type of the Detector.
     * 
     * @return the type value.
     */
    public IssueType type() {
        return this.type;
    }

    /**
     * Set the type property: Represents the type of the Detector.
     * 
     * @param type the type value to set.
     * @return the DetectorAbnormalTimePeriod object itself.
     */
    public DetectorAbnormalTimePeriod withType(IssueType type) {
        this.type = type;
        return this;
    }

    /**
     * Get the solutions property: List of proposed solutions.
     * 
     * @return the solutions value.
     */
    public List<Solution> solutions() {
        return this.solutions;
    }

    /**
     * Set the solutions property: List of proposed solutions.
     * 
     * @param solutions the solutions value to set.
     * @return the DetectorAbnormalTimePeriod object itself.
     */
    public DetectorAbnormalTimePeriod withSolutions(List<Solution> solutions) {
        this.solutions = solutions;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (metadata() != null) {
            metadata().forEach(e -> e.forEach(e1 -> e1.validate()));
        }
        if (solutions() != null) {
            solutions().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("startTime",
            this.startTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startTime));
        jsonWriter.writeStringField("endTime",
            this.endTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.endTime));
        jsonWriter.writeStringField("message", this.message);
        jsonWriter.writeStringField("source", this.source);
        jsonWriter.writeNumberField("priority", this.priority);
        jsonWriter.writeArrayField("metaData", this.metadata,
            (writer, element) -> writer.writeArray(element, (writer1, element1) -> writer1.writeJson(element1)));
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeArrayField("solutions", this.solutions, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DetectorAbnormalTimePeriod from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DetectorAbnormalTimePeriod if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DetectorAbnormalTimePeriod.
     */
    public static DetectorAbnormalTimePeriod fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DetectorAbnormalTimePeriod deserializedDetectorAbnormalTimePeriod = new DetectorAbnormalTimePeriod();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("startTime".equals(fieldName)) {
                    deserializedDetectorAbnormalTimePeriod.startTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("endTime".equals(fieldName)) {
                    deserializedDetectorAbnormalTimePeriod.endTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("message".equals(fieldName)) {
                    deserializedDetectorAbnormalTimePeriod.message = reader.getString();
                } else if ("source".equals(fieldName)) {
                    deserializedDetectorAbnormalTimePeriod.source = reader.getString();
                } else if ("priority".equals(fieldName)) {
                    deserializedDetectorAbnormalTimePeriod.priority = reader.getNullable(JsonReader::getDouble);
                } else if ("metaData".equals(fieldName)) {
                    List<List<NameValuePair>> metadata
                        = reader.readArray(reader1 -> reader1.readArray(reader2 -> NameValuePair.fromJson(reader2)));
                    deserializedDetectorAbnormalTimePeriod.metadata = metadata;
                } else if ("type".equals(fieldName)) {
                    deserializedDetectorAbnormalTimePeriod.type = IssueType.fromString(reader.getString());
                } else if ("solutions".equals(fieldName)) {
                    List<Solution> solutions = reader.readArray(reader1 -> Solution.fromJson(reader1));
                    deserializedDetectorAbnormalTimePeriod.solutions = solutions;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDetectorAbnormalTimePeriod;
        });
    }
}
