// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

/**
 * Indicates whether the hostname is a standard or repository hostname.
 */
public enum HostType {
    /**
     * Enum value Standard.
     */
    STANDARD("Standard"),

    /**
     * Enum value Repository.
     */
    REPOSITORY("Repository");

    /**
     * The actual serialized value for a HostType instance.
     */
    private final String value;

    HostType(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a HostType instance.
     * 
     * @param value the serialized value to parse.
     * @return the parsed HostType object, or null if unable to parse.
     */
    public static HostType fromString(String value) {
        if (value == null) {
            return null;
        }
        HostType[] items = HostType.values();
        for (HostType item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String toString() {
        return this.value;
    }
}
