// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Details of a hostname derived from a domain.
 */
@Fluent
public final class Hostname implements JsonSerializable<Hostname> {
    /*
     * Name of the hostname.
     */
    private String name;

    /*
     * List of apps the hostname is assigned to. This list will have more than one app only if the hostname is pointing
     * to a Traffic Manager.
     */
    private List<String> siteNames;

    /*
     * Name of the Azure resource the hostname is assigned to. If it is assigned to a Traffic Manager then it will be
     * the Traffic Manager name otherwise it will be the app name.
     */
    private String azureResourceName;

    /*
     * Type of the Azure resource the hostname is assigned to.
     */
    private AzureResourceType azureResourceType;

    /*
     * Type of the DNS record.
     */
    private CustomHostnameDnsRecordType customHostnameDnsRecordType;

    /*
     * Type of the hostname.
     */
    private HostnameType hostnameType;

    /**
     * Creates an instance of Hostname class.
     */
    public Hostname() {
    }

    /**
     * Get the name property: Name of the hostname.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Name of the hostname.
     * 
     * @param name the name value to set.
     * @return the Hostname object itself.
     */
    public Hostname withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the siteNames property: List of apps the hostname is assigned to. This list will have more than one app only
     * if the hostname is pointing to a Traffic Manager.
     * 
     * @return the siteNames value.
     */
    public List<String> siteNames() {
        return this.siteNames;
    }

    /**
     * Set the siteNames property: List of apps the hostname is assigned to. This list will have more than one app only
     * if the hostname is pointing to a Traffic Manager.
     * 
     * @param siteNames the siteNames value to set.
     * @return the Hostname object itself.
     */
    public Hostname withSiteNames(List<String> siteNames) {
        this.siteNames = siteNames;
        return this;
    }

    /**
     * Get the azureResourceName property: Name of the Azure resource the hostname is assigned to. If it is assigned to
     * a Traffic Manager then it will be the Traffic Manager name otherwise it will be the app name.
     * 
     * @return the azureResourceName value.
     */
    public String azureResourceName() {
        return this.azureResourceName;
    }

    /**
     * Set the azureResourceName property: Name of the Azure resource the hostname is assigned to. If it is assigned to
     * a Traffic Manager then it will be the Traffic Manager name otherwise it will be the app name.
     * 
     * @param azureResourceName the azureResourceName value to set.
     * @return the Hostname object itself.
     */
    public Hostname withAzureResourceName(String azureResourceName) {
        this.azureResourceName = azureResourceName;
        return this;
    }

    /**
     * Get the azureResourceType property: Type of the Azure resource the hostname is assigned to.
     * 
     * @return the azureResourceType value.
     */
    public AzureResourceType azureResourceType() {
        return this.azureResourceType;
    }

    /**
     * Set the azureResourceType property: Type of the Azure resource the hostname is assigned to.
     * 
     * @param azureResourceType the azureResourceType value to set.
     * @return the Hostname object itself.
     */
    public Hostname withAzureResourceType(AzureResourceType azureResourceType) {
        this.azureResourceType = azureResourceType;
        return this;
    }

    /**
     * Get the customHostnameDnsRecordType property: Type of the DNS record.
     * 
     * @return the customHostnameDnsRecordType value.
     */
    public CustomHostnameDnsRecordType customHostnameDnsRecordType() {
        return this.customHostnameDnsRecordType;
    }

    /**
     * Set the customHostnameDnsRecordType property: Type of the DNS record.
     * 
     * @param customHostnameDnsRecordType the customHostnameDnsRecordType value to set.
     * @return the Hostname object itself.
     */
    public Hostname withCustomHostnameDnsRecordType(CustomHostnameDnsRecordType customHostnameDnsRecordType) {
        this.customHostnameDnsRecordType = customHostnameDnsRecordType;
        return this;
    }

    /**
     * Get the hostnameType property: Type of the hostname.
     * 
     * @return the hostnameType value.
     */
    public HostnameType hostnameType() {
        return this.hostnameType;
    }

    /**
     * Set the hostnameType property: Type of the hostname.
     * 
     * @param hostnameType the hostnameType value to set.
     * @return the Hostname object itself.
     */
    public Hostname withHostnameType(HostnameType hostnameType) {
        this.hostnameType = hostnameType;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeArrayField("siteNames", this.siteNames, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("azureResourceName", this.azureResourceName);
        jsonWriter.writeStringField("azureResourceType",
            this.azureResourceType == null ? null : this.azureResourceType.toString());
        jsonWriter.writeStringField("customHostNameDnsRecordType",
            this.customHostnameDnsRecordType == null ? null : this.customHostnameDnsRecordType.toString());
        jsonWriter.writeStringField("hostNameType", this.hostnameType == null ? null : this.hostnameType.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of Hostname from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of Hostname if the JsonReader was pointing to an instance of it, or null if it was pointing
     * to JSON null.
     * @throws IOException If an error occurs while reading the Hostname.
     */
    public static Hostname fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            Hostname deserializedHostname = new Hostname();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedHostname.name = reader.getString();
                } else if ("siteNames".equals(fieldName)) {
                    List<String> siteNames = reader.readArray(reader1 -> reader1.getString());
                    deserializedHostname.siteNames = siteNames;
                } else if ("azureResourceName".equals(fieldName)) {
                    deserializedHostname.azureResourceName = reader.getString();
                } else if ("azureResourceType".equals(fieldName)) {
                    deserializedHostname.azureResourceType = AzureResourceType.fromString(reader.getString());
                } else if ("customHostNameDnsRecordType".equals(fieldName)) {
                    deserializedHostname.customHostnameDnsRecordType
                        = CustomHostnameDnsRecordType.fromString(reader.getString());
                } else if ("hostNameType".equals(fieldName)) {
                    deserializedHostname.hostnameType = HostnameType.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedHostname;
        });
    }
}
