// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.fluent.models.StaticSiteUserInvitationRequestResourceProperties;
import java.io.IOException;

/**
 * Static sites user roles invitation resource.
 */
@Fluent
public final class StaticSiteUserInvitationRequestResource extends ProxyOnlyResource {
    /*
     * StaticSiteUserInvitationRequestResource resource specific properties
     */
    private StaticSiteUserInvitationRequestResourceProperties innerProperties;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of StaticSiteUserInvitationRequestResource class.
     */
    public StaticSiteUserInvitationRequestResource() {
    }

    /**
     * Get the innerProperties property: StaticSiteUserInvitationRequestResource resource specific properties.
     * 
     * @return the innerProperties value.
     */
    private StaticSiteUserInvitationRequestResourceProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public StaticSiteUserInvitationRequestResource withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    /**
     * Get the domain property: The domain name for the static site custom domain.
     * 
     * @return the domain value.
     */
    public String domain() {
        return this.innerProperties() == null ? null : this.innerProperties().domain();
    }

    /**
     * Set the domain property: The domain name for the static site custom domain.
     * 
     * @param domain the domain value to set.
     * @return the StaticSiteUserInvitationRequestResource object itself.
     */
    public StaticSiteUserInvitationRequestResource withDomain(String domain) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StaticSiteUserInvitationRequestResourceProperties();
        }
        this.innerProperties().withDomain(domain);
        return this;
    }

    /**
     * Get the provider property: The identity provider for the static site user.
     * 
     * @return the provider value.
     */
    public String provider() {
        return this.innerProperties() == null ? null : this.innerProperties().provider();
    }

    /**
     * Set the provider property: The identity provider for the static site user.
     * 
     * @param provider the provider value to set.
     * @return the StaticSiteUserInvitationRequestResource object itself.
     */
    public StaticSiteUserInvitationRequestResource withProvider(String provider) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StaticSiteUserInvitationRequestResourceProperties();
        }
        this.innerProperties().withProvider(provider);
        return this;
    }

    /**
     * Get the userDetails property: The user id for the static site user.
     * 
     * @return the userDetails value.
     */
    public String userDetails() {
        return this.innerProperties() == null ? null : this.innerProperties().userDetails();
    }

    /**
     * Set the userDetails property: The user id for the static site user.
     * 
     * @param userDetails the userDetails value to set.
     * @return the StaticSiteUserInvitationRequestResource object itself.
     */
    public StaticSiteUserInvitationRequestResource withUserDetails(String userDetails) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StaticSiteUserInvitationRequestResourceProperties();
        }
        this.innerProperties().withUserDetails(userDetails);
        return this;
    }

    /**
     * Get the roles property: The roles for the static site user, in free-form string format.
     * 
     * @return the roles value.
     */
    public String roles() {
        return this.innerProperties() == null ? null : this.innerProperties().roles();
    }

    /**
     * Set the roles property: The roles for the static site user, in free-form string format.
     * 
     * @param roles the roles value to set.
     * @return the StaticSiteUserInvitationRequestResource object itself.
     */
    public StaticSiteUserInvitationRequestResource withRoles(String roles) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StaticSiteUserInvitationRequestResourceProperties();
        }
        this.innerProperties().withRoles(roles);
        return this;
    }

    /**
     * Get the numHoursToExpiration property: The number of hours the sas token stays valid.
     * 
     * @return the numHoursToExpiration value.
     */
    public Integer numHoursToExpiration() {
        return this.innerProperties() == null ? null : this.innerProperties().numHoursToExpiration();
    }

    /**
     * Set the numHoursToExpiration property: The number of hours the sas token stays valid.
     * 
     * @param numHoursToExpiration the numHoursToExpiration value to set.
     * @return the StaticSiteUserInvitationRequestResource object itself.
     */
    public StaticSiteUserInvitationRequestResource withNumHoursToExpiration(Integer numHoursToExpiration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StaticSiteUserInvitationRequestResourceProperties();
        }
        this.innerProperties().withNumHoursToExpiration(numHoursToExpiration);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", kind());
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of StaticSiteUserInvitationRequestResource from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of StaticSiteUserInvitationRequestResource if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the StaticSiteUserInvitationRequestResource.
     */
    public static StaticSiteUserInvitationRequestResource fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            StaticSiteUserInvitationRequestResource deserializedStaticSiteUserInvitationRequestResource
                = new StaticSiteUserInvitationRequestResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedStaticSiteUserInvitationRequestResource.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedStaticSiteUserInvitationRequestResource.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedStaticSiteUserInvitationRequestResource.type = reader.getString();
                } else if ("kind".equals(fieldName)) {
                    deserializedStaticSiteUserInvitationRequestResource.withKind(reader.getString());
                } else if ("properties".equals(fieldName)) {
                    deserializedStaticSiteUserInvitationRequestResource.innerProperties
                        = StaticSiteUserInvitationRequestResourceProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedStaticSiteUserInvitationRequestResource;
        });
    }
}
