// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;

/**
 * The workflow run trigger.
 */
@Fluent
public final class WorkflowRunTrigger implements JsonSerializable<WorkflowRunTrigger> {
    /*
     * Gets the name.
     */
    private String name;

    /*
     * Gets the inputs.
     */
    private Object inputs;

    /*
     * Gets the link to inputs.
     */
    private ContentLink inputsLink;

    /*
     * Gets the outputs.
     */
    private Object outputs;

    /*
     * Gets the link to outputs.
     */
    private ContentLink outputsLink;

    /*
     * Gets the scheduled time.
     */
    private OffsetDateTime scheduledTime;

    /*
     * Gets the start time.
     */
    private OffsetDateTime startTime;

    /*
     * Gets the end time.
     */
    private OffsetDateTime endTime;

    /*
     * Gets the tracking id.
     */
    private String trackingId;

    /*
     * The run correlation.
     */
    private Correlation correlation;

    /*
     * Gets the code.
     */
    private String code;

    /*
     * Gets the status.
     */
    private WorkflowStatus status;

    /*
     * Gets the error.
     */
    private Object error;

    /*
     * Gets the tracked properties.
     */
    private Object trackedProperties;

    /**
     * Creates an instance of WorkflowRunTrigger class.
     */
    public WorkflowRunTrigger() {
    }

    /**
     * Get the name property: Gets the name.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the inputs property: Gets the inputs.
     * 
     * @return the inputs value.
     */
    public Object inputs() {
        return this.inputs;
    }

    /**
     * Get the inputsLink property: Gets the link to inputs.
     * 
     * @return the inputsLink value.
     */
    public ContentLink inputsLink() {
        return this.inputsLink;
    }

    /**
     * Get the outputs property: Gets the outputs.
     * 
     * @return the outputs value.
     */
    public Object outputs() {
        return this.outputs;
    }

    /**
     * Get the outputsLink property: Gets the link to outputs.
     * 
     * @return the outputsLink value.
     */
    public ContentLink outputsLink() {
        return this.outputsLink;
    }

    /**
     * Get the scheduledTime property: Gets the scheduled time.
     * 
     * @return the scheduledTime value.
     */
    public OffsetDateTime scheduledTime() {
        return this.scheduledTime;
    }

    /**
     * Get the startTime property: Gets the start time.
     * 
     * @return the startTime value.
     */
    public OffsetDateTime startTime() {
        return this.startTime;
    }

    /**
     * Get the endTime property: Gets the end time.
     * 
     * @return the endTime value.
     */
    public OffsetDateTime endTime() {
        return this.endTime;
    }

    /**
     * Get the trackingId property: Gets the tracking id.
     * 
     * @return the trackingId value.
     */
    public String trackingId() {
        return this.trackingId;
    }

    /**
     * Get the correlation property: The run correlation.
     * 
     * @return the correlation value.
     */
    public Correlation correlation() {
        return this.correlation;
    }

    /**
     * Set the correlation property: The run correlation.
     * 
     * @param correlation the correlation value to set.
     * @return the WorkflowRunTrigger object itself.
     */
    public WorkflowRunTrigger withCorrelation(Correlation correlation) {
        this.correlation = correlation;
        return this;
    }

    /**
     * Get the code property: Gets the code.
     * 
     * @return the code value.
     */
    public String code() {
        return this.code;
    }

    /**
     * Get the status property: Gets the status.
     * 
     * @return the status value.
     */
    public WorkflowStatus status() {
        return this.status;
    }

    /**
     * Get the error property: Gets the error.
     * 
     * @return the error value.
     */
    public Object error() {
        return this.error;
    }

    /**
     * Get the trackedProperties property: Gets the tracked properties.
     * 
     * @return the trackedProperties value.
     */
    public Object trackedProperties() {
        return this.trackedProperties;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (inputsLink() != null) {
            inputsLink().validate();
        }
        if (outputsLink() != null) {
            outputsLink().validate();
        }
        if (correlation() != null) {
            correlation().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("correlation", this.correlation);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of WorkflowRunTrigger from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of WorkflowRunTrigger if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the WorkflowRunTrigger.
     */
    public static WorkflowRunTrigger fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            WorkflowRunTrigger deserializedWorkflowRunTrigger = new WorkflowRunTrigger();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedWorkflowRunTrigger.name = reader.getString();
                } else if ("inputs".equals(fieldName)) {
                    deserializedWorkflowRunTrigger.inputs = reader.readUntyped();
                } else if ("inputsLink".equals(fieldName)) {
                    deserializedWorkflowRunTrigger.inputsLink = ContentLink.fromJson(reader);
                } else if ("outputs".equals(fieldName)) {
                    deserializedWorkflowRunTrigger.outputs = reader.readUntyped();
                } else if ("outputsLink".equals(fieldName)) {
                    deserializedWorkflowRunTrigger.outputsLink = ContentLink.fromJson(reader);
                } else if ("scheduledTime".equals(fieldName)) {
                    deserializedWorkflowRunTrigger.scheduledTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("startTime".equals(fieldName)) {
                    deserializedWorkflowRunTrigger.startTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("endTime".equals(fieldName)) {
                    deserializedWorkflowRunTrigger.endTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("trackingId".equals(fieldName)) {
                    deserializedWorkflowRunTrigger.trackingId = reader.getString();
                } else if ("correlation".equals(fieldName)) {
                    deserializedWorkflowRunTrigger.correlation = Correlation.fromJson(reader);
                } else if ("code".equals(fieldName)) {
                    deserializedWorkflowRunTrigger.code = reader.getString();
                } else if ("status".equals(fieldName)) {
                    deserializedWorkflowRunTrigger.status = WorkflowStatus.fromString(reader.getString());
                } else if ("error".equals(fieldName)) {
                    deserializedWorkflowRunTrigger.error = reader.readUntyped();
                } else if ("trackedProperties".equals(fieldName)) {
                    deserializedWorkflowRunTrigger.trackedProperties = reader.readUntyped();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedWorkflowRunTrigger;
        });
    }
}
