/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.fluent.models.ResourceMetricDefinitionProperties;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import com.azure.resourcemanager.appservice.models.ResourceMetricAvailability;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class ResourceMetricDefinitionInner
extends ProxyOnlyResource {
    private ResourceMetricDefinitionProperties innerProperties;
    private String type;
    private String name;
    private String id;

    private ResourceMetricDefinitionProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public ResourceMetricDefinitionInner withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    public String unit() {
        return this.innerProperties() == null ? null : this.innerProperties().unit();
    }

    public String primaryAggregationType() {
        return this.innerProperties() == null ? null : this.innerProperties().primaryAggregationType();
    }

    public List<ResourceMetricAvailability> metricAvailabilities() {
        return this.innerProperties() == null ? null : this.innerProperties().metricAvailabilities();
    }

    public String resourceUri() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceUri();
    }

    public Map<String, String> properties() {
        return this.innerProperties() == null ? null : this.innerProperties().properties();
    }

    @Override
    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", this.kind());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static ResourceMetricDefinitionInner fromJson(JsonReader jsonReader) throws IOException {
        return (ResourceMetricDefinitionInner)((Object)jsonReader.readObject(reader -> {
            ResourceMetricDefinitionInner deserializedResourceMetricDefinitionInner = new ResourceMetricDefinitionInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedResourceMetricDefinitionInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedResourceMetricDefinitionInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedResourceMetricDefinitionInner.type = reader.getString();
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedResourceMetricDefinitionInner.withKind(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedResourceMetricDefinitionInner.innerProperties = ResourceMetricDefinitionProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedResourceMetricDefinitionInner;
        }));
    }
}

