// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.appservice.fluent.models.CertificateInner;
import com.azure.resourcemanager.appservice.models.CertificatePatchResource;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in SiteCertificatesClient.
 */
public interface SiteCertificatesClient {
    /**
     * Get all certificates in a resource group under a site.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name Name of the site.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all certificates in a resource group under a site as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<CertificateInner> listAsync(String resourceGroupName, String name);

    /**
     * Get all certificates in a resource group under a site.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name Name of the site.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all certificates in a resource group under a site as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<CertificateInner> list(String resourceGroupName, String name);

    /**
     * Get all certificates in a resource group under a site.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name Name of the site.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all certificates in a resource group under a site as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<CertificateInner> list(String resourceGroupName, String name, Context context);

    /**
     * Get a certificate belonging to a given site.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name Name of the site.
     * @param certificateName Name of the certificate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a certificate belonging to a given site along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<CertificateInner>> getWithResponseAsync(String resourceGroupName, String name,
        String certificateName);

    /**
     * Get a certificate belonging to a given site.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name Name of the site.
     * @param certificateName Name of the certificate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a certificate belonging to a given site on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<CertificateInner> getAsync(String resourceGroupName, String name, String certificateName);

    /**
     * Get a certificate belonging to a given site.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name Name of the site.
     * @param certificateName Name of the certificate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a certificate belonging to a given site along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<CertificateInner> getWithResponse(String resourceGroupName, String name, String certificateName,
        Context context);

    /**
     * Get a certificate belonging to a given site.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name Name of the site.
     * @param certificateName Name of the certificate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a certificate belonging to a given site.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    CertificateInner get(String resourceGroupName, String name, String certificateName);

    /**
     * Create or update a certificate under a given site.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name Name of the site.
     * @param certificateName Name of the certificate.
     * @param certificateEnvelope Details of certificate, if it exists already.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return sSL certificate for an app along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<CertificateInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String name,
        String certificateName, CertificateInner certificateEnvelope);

    /**
     * Create or update a certificate under a given site.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name Name of the site.
     * @param certificateName Name of the certificate.
     * @param certificateEnvelope Details of certificate, if it exists already.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return sSL certificate for an app on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<CertificateInner> createOrUpdateAsync(String resourceGroupName, String name, String certificateName,
        CertificateInner certificateEnvelope);

    /**
     * Create or update a certificate under a given site.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name Name of the site.
     * @param certificateName Name of the certificate.
     * @param certificateEnvelope Details of certificate, if it exists already.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return sSL certificate for an app along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<CertificateInner> createOrUpdateWithResponse(String resourceGroupName, String name, String certificateName,
        CertificateInner certificateEnvelope, Context context);

    /**
     * Create or update a certificate under a given site.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name Name of the site.
     * @param certificateName Name of the certificate.
     * @param certificateEnvelope Details of certificate, if it exists already.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return sSL certificate for an app.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    CertificateInner createOrUpdate(String resourceGroupName, String name, String certificateName,
        CertificateInner certificateEnvelope);

    /**
     * Delete a certificate from the site.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name Name of the site.
     * @param certificateName Name of the certificate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String name, String certificateName);

    /**
     * Delete a certificate from the site.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name Name of the site.
     * @param certificateName Name of the certificate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteAsync(String resourceGroupName, String name, String certificateName);

    /**
     * Delete a certificate from the site.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name Name of the site.
     * @param certificateName Name of the certificate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> deleteWithResponse(String resourceGroupName, String name, String certificateName, Context context);

    /**
     * Delete a certificate from the site.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name Name of the site.
     * @param certificateName Name of the certificate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String name, String certificateName);

    /**
     * Create or update a certificate under a given site.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name Name of the site.
     * @param certificateName Name of the certificate.
     * @param certificateEnvelope Details of certificate, if it exists already.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return sSL certificate for an app along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<CertificateInner>> updateWithResponseAsync(String resourceGroupName, String name,
        String certificateName, CertificatePatchResource certificateEnvelope);

    /**
     * Create or update a certificate under a given site.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name Name of the site.
     * @param certificateName Name of the certificate.
     * @param certificateEnvelope Details of certificate, if it exists already.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return sSL certificate for an app on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<CertificateInner> updateAsync(String resourceGroupName, String name, String certificateName,
        CertificatePatchResource certificateEnvelope);

    /**
     * Create or update a certificate under a given site.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name Name of the site.
     * @param certificateName Name of the certificate.
     * @param certificateEnvelope Details of certificate, if it exists already.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return sSL certificate for an app along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<CertificateInner> updateWithResponse(String resourceGroupName, String name, String certificateName,
        CertificatePatchResource certificateEnvelope, Context context);

    /**
     * Create or update a certificate under a given site.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name Name of the site.
     * @param certificateName Name of the certificate.
     * @param certificateEnvelope Details of certificate, if it exists already.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return sSL certificate for an app.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    CertificateInner update(String resourceGroupName, String name, String certificateName,
        CertificatePatchResource certificateEnvelope);

    /**
     * Get all certificates in a resource group for a given site and a deployment slot.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name Name of the site.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will create a binding for the
     * production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all certificates in a resource group for a given site and a deployment slot as paginated response with
     * {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<CertificateInner> listSlotAsync(String resourceGroupName, String name, String slot);

    /**
     * Get all certificates in a resource group for a given site and a deployment slot.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name Name of the site.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will create a binding for the
     * production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all certificates in a resource group for a given site and a deployment slot as paginated response with
     * {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<CertificateInner> listSlot(String resourceGroupName, String name, String slot);

    /**
     * Get all certificates in a resource group for a given site and a deployment slot.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name Name of the site.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will create a binding for the
     * production slot.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all certificates in a resource group for a given site and a deployment slot as paginated response with
     * {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<CertificateInner> listSlot(String resourceGroupName, String name, String slot, Context context);

    /**
     * Get a certificate for a given site and deployment slot.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name Name of the site.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will create a binding for the
     * production slot.
     * @param certificateName Name of the certificate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a certificate for a given site and deployment slot along with {@link Response} on successful completion
     * of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<CertificateInner>> getSlotWithResponseAsync(String resourceGroupName, String name, String slot,
        String certificateName);

    /**
     * Get a certificate for a given site and deployment slot.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name Name of the site.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will create a binding for the
     * production slot.
     * @param certificateName Name of the certificate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a certificate for a given site and deployment slot on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<CertificateInner> getSlotAsync(String resourceGroupName, String name, String slot, String certificateName);

    /**
     * Get a certificate for a given site and deployment slot.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name Name of the site.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will create a binding for the
     * production slot.
     * @param certificateName Name of the certificate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a certificate for a given site and deployment slot along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<CertificateInner> getSlotWithResponse(String resourceGroupName, String name, String slot,
        String certificateName, Context context);

    /**
     * Get a certificate for a given site and deployment slot.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name Name of the site.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will create a binding for the
     * production slot.
     * @param certificateName Name of the certificate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a certificate for a given site and deployment slot.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    CertificateInner getSlot(String resourceGroupName, String name, String slot, String certificateName);

    /**
     * Create or update a certificate in a given site and deployment slot.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name Name of the site.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will create a binding for the
     * production slot.
     * @param certificateName Name of the certificate.
     * @param certificateEnvelope Details of certificate, if it exists already.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return sSL certificate for an app along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<CertificateInner>> createOrUpdateSlotWithResponseAsync(String resourceGroupName, String name,
        String slot, String certificateName, CertificateInner certificateEnvelope);

    /**
     * Create or update a certificate in a given site and deployment slot.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name Name of the site.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will create a binding for the
     * production slot.
     * @param certificateName Name of the certificate.
     * @param certificateEnvelope Details of certificate, if it exists already.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return sSL certificate for an app on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<CertificateInner> createOrUpdateSlotAsync(String resourceGroupName, String name, String slot,
        String certificateName, CertificateInner certificateEnvelope);

    /**
     * Create or update a certificate in a given site and deployment slot.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name Name of the site.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will create a binding for the
     * production slot.
     * @param certificateName Name of the certificate.
     * @param certificateEnvelope Details of certificate, if it exists already.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return sSL certificate for an app along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<CertificateInner> createOrUpdateSlotWithResponse(String resourceGroupName, String name, String slot,
        String certificateName, CertificateInner certificateEnvelope, Context context);

    /**
     * Create or update a certificate in a given site and deployment slot.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name Name of the site.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will create a binding for the
     * production slot.
     * @param certificateName Name of the certificate.
     * @param certificateEnvelope Details of certificate, if it exists already.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return sSL certificate for an app.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    CertificateInner createOrUpdateSlot(String resourceGroupName, String name, String slot, String certificateName,
        CertificateInner certificateEnvelope);

    /**
     * Delete a certificate for a given site and deployment slot.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name Name of the site.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will create a binding for the
     * production slot.
     * @param certificateName Name of the certificate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> deleteSlotWithResponseAsync(String resourceGroupName, String name, String slot,
        String certificateName);

    /**
     * Delete a certificate for a given site and deployment slot.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name Name of the site.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will create a binding for the
     * production slot.
     * @param certificateName Name of the certificate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteSlotAsync(String resourceGroupName, String name, String slot, String certificateName);

    /**
     * Delete a certificate for a given site and deployment slot.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name Name of the site.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will create a binding for the
     * production slot.
     * @param certificateName Name of the certificate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> deleteSlotWithResponse(String resourceGroupName, String name, String slot, String certificateName,
        Context context);

    /**
     * Delete a certificate for a given site and deployment slot.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name Name of the site.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will create a binding for the
     * production slot.
     * @param certificateName Name of the certificate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void deleteSlot(String resourceGroupName, String name, String slot, String certificateName);

    /**
     * Create or update a certificate for a site and deployment slot.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name Name of the site.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will create a binding for the
     * production slot.
     * @param certificateName Name of the certificate.
     * @param certificateEnvelope Details of certificate, if it exists already.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return sSL certificate for an app along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<CertificateInner>> updateSlotWithResponseAsync(String resourceGroupName, String name, String slot,
        String certificateName, CertificatePatchResource certificateEnvelope);

    /**
     * Create or update a certificate for a site and deployment slot.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name Name of the site.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will create a binding for the
     * production slot.
     * @param certificateName Name of the certificate.
     * @param certificateEnvelope Details of certificate, if it exists already.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return sSL certificate for an app on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<CertificateInner> updateSlotAsync(String resourceGroupName, String name, String slot, String certificateName,
        CertificatePatchResource certificateEnvelope);

    /**
     * Create or update a certificate for a site and deployment slot.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name Name of the site.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will create a binding for the
     * production slot.
     * @param certificateName Name of the certificate.
     * @param certificateEnvelope Details of certificate, if it exists already.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return sSL certificate for an app along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<CertificateInner> updateSlotWithResponse(String resourceGroupName, String name, String slot,
        String certificateName, CertificatePatchResource certificateEnvelope, Context context);

    /**
     * Create or update a certificate for a site and deployment slot.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param name Name of the site.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will create a binding for the
     * production slot.
     * @param certificateName Name of the certificate.
     * @param certificateEnvelope Details of certificate, if it exists already.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     * rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return sSL certificate for an app.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    CertificateInner updateSlot(String resourceGroupName, String name, String slot, String certificateName,
        CertificatePatchResource certificateEnvelope);
}
