// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.HostingEnvironmentDeploymentInfo;
import java.io.IOException;
import java.util.List;

/**
 * List of available locations (regions or App Service Environments) for
 * deployment of App Service resources.
 */
@Fluent
public final class DeploymentLocationsInner implements JsonSerializable<DeploymentLocationsInner> {
    /*
     * Available regions.
     */
    private List<GeoRegionInner> locations;

    /*
     * Available App Service Environments with full descriptions of the environments.
     */
    private List<AppServiceEnvironmentInner> hostingEnvironments;

    /*
     * Available App Service Environments with basic information.
     */
    private List<HostingEnvironmentDeploymentInfo> hostingEnvironmentDeploymentInfos;

    /**
     * Creates an instance of DeploymentLocationsInner class.
     */
    public DeploymentLocationsInner() {
    }

    /**
     * Get the locations property: Available regions.
     * 
     * @return the locations value.
     */
    public List<GeoRegionInner> locations() {
        return this.locations;
    }

    /**
     * Set the locations property: Available regions.
     * 
     * @param locations the locations value to set.
     * @return the DeploymentLocationsInner object itself.
     */
    public DeploymentLocationsInner withLocations(List<GeoRegionInner> locations) {
        this.locations = locations;
        return this;
    }

    /**
     * Get the hostingEnvironments property: Available App Service Environments with full descriptions of the
     * environments.
     * 
     * @return the hostingEnvironments value.
     */
    public List<AppServiceEnvironmentInner> hostingEnvironments() {
        return this.hostingEnvironments;
    }

    /**
     * Set the hostingEnvironments property: Available App Service Environments with full descriptions of the
     * environments.
     * 
     * @param hostingEnvironments the hostingEnvironments value to set.
     * @return the DeploymentLocationsInner object itself.
     */
    public DeploymentLocationsInner withHostingEnvironments(List<AppServiceEnvironmentInner> hostingEnvironments) {
        this.hostingEnvironments = hostingEnvironments;
        return this;
    }

    /**
     * Get the hostingEnvironmentDeploymentInfos property: Available App Service Environments with basic information.
     * 
     * @return the hostingEnvironmentDeploymentInfos value.
     */
    public List<HostingEnvironmentDeploymentInfo> hostingEnvironmentDeploymentInfos() {
        return this.hostingEnvironmentDeploymentInfos;
    }

    /**
     * Set the hostingEnvironmentDeploymentInfos property: Available App Service Environments with basic information.
     * 
     * @param hostingEnvironmentDeploymentInfos the hostingEnvironmentDeploymentInfos value to set.
     * @return the DeploymentLocationsInner object itself.
     */
    public DeploymentLocationsInner withHostingEnvironmentDeploymentInfos(
        List<HostingEnvironmentDeploymentInfo> hostingEnvironmentDeploymentInfos) {
        this.hostingEnvironmentDeploymentInfos = hostingEnvironmentDeploymentInfos;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (locations() != null) {
            locations().forEach(e -> e.validate());
        }
        if (hostingEnvironments() != null) {
            hostingEnvironments().forEach(e -> e.validate());
        }
        if (hostingEnvironmentDeploymentInfos() != null) {
            hostingEnvironmentDeploymentInfos().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("locations", this.locations, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("hostingEnvironments", this.hostingEnvironments,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("hostingEnvironmentDeploymentInfos", this.hostingEnvironmentDeploymentInfos,
            (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DeploymentLocationsInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DeploymentLocationsInner if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DeploymentLocationsInner.
     */
    public static DeploymentLocationsInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DeploymentLocationsInner deserializedDeploymentLocationsInner = new DeploymentLocationsInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("locations".equals(fieldName)) {
                    List<GeoRegionInner> locations = reader.readArray(reader1 -> GeoRegionInner.fromJson(reader1));
                    deserializedDeploymentLocationsInner.locations = locations;
                } else if ("hostingEnvironments".equals(fieldName)) {
                    List<AppServiceEnvironmentInner> hostingEnvironments
                        = reader.readArray(reader1 -> AppServiceEnvironmentInner.fromJson(reader1));
                    deserializedDeploymentLocationsInner.hostingEnvironments = hostingEnvironments;
                } else if ("hostingEnvironmentDeploymentInfos".equals(fieldName)) {
                    List<HostingEnvironmentDeploymentInfo> hostingEnvironmentDeploymentInfos
                        = reader.readArray(reader1 -> HostingEnvironmentDeploymentInfo.fromJson(reader1));
                    deserializedDeploymentLocationsInner.hostingEnvironmentDeploymentInfos
                        = hostingEnvironmentDeploymentInfos;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDeploymentLocationsInner;
        });
    }
}
