// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.MySqlMigrationType;
import java.io.IOException;

/**
 * MigrateMySqlRequest resource specific properties.
 */
@Fluent
public final class MigrateMySqlRequestProperties implements JsonSerializable<MigrateMySqlRequestProperties> {
    /*
     * Connection string to the remote MySQL database.
     */
    private String connectionString;

    /*
     * The type of migration operation to be done
     */
    private MySqlMigrationType migrationType;

    /**
     * Creates an instance of MigrateMySqlRequestProperties class.
     */
    public MigrateMySqlRequestProperties() {
    }

    /**
     * Get the connectionString property: Connection string to the remote MySQL database.
     * 
     * @return the connectionString value.
     */
    public String connectionString() {
        return this.connectionString;
    }

    /**
     * Set the connectionString property: Connection string to the remote MySQL database.
     * 
     * @param connectionString the connectionString value to set.
     * @return the MigrateMySqlRequestProperties object itself.
     */
    public MigrateMySqlRequestProperties withConnectionString(String connectionString) {
        this.connectionString = connectionString;
        return this;
    }

    /**
     * Get the migrationType property: The type of migration operation to be done.
     * 
     * @return the migrationType value.
     */
    public MySqlMigrationType migrationType() {
        return this.migrationType;
    }

    /**
     * Set the migrationType property: The type of migration operation to be done.
     * 
     * @param migrationType the migrationType value to set.
     * @return the MigrateMySqlRequestProperties object itself.
     */
    public MigrateMySqlRequestProperties withMigrationType(MySqlMigrationType migrationType) {
        this.migrationType = migrationType;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (connectionString() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property connectionString in model MigrateMySqlRequestProperties"));
        }
        if (migrationType() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property migrationType in model MigrateMySqlRequestProperties"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(MigrateMySqlRequestProperties.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("connectionString", this.connectionString);
        jsonWriter.writeStringField("migrationType", this.migrationType == null ? null : this.migrationType.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MigrateMySqlRequestProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MigrateMySqlRequestProperties if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the MigrateMySqlRequestProperties.
     */
    public static MigrateMySqlRequestProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MigrateMySqlRequestProperties deserializedMigrateMySqlRequestProperties
                = new MigrateMySqlRequestProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("connectionString".equals(fieldName)) {
                    deserializedMigrateMySqlRequestProperties.connectionString = reader.getString();
                } else if ("migrationType".equals(fieldName)) {
                    deserializedMigrateMySqlRequestProperties.migrationType
                        = MySqlMigrationType.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedMigrateMySqlRequestProperties;
        });
    }
}
