// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.FlowAccessControlConfiguration;
import com.azure.resourcemanager.appservice.models.FlowEndpointsConfiguration;
import com.azure.resourcemanager.appservice.models.ResourceReference;
import com.azure.resourcemanager.appservice.models.WorkflowParameter;
import com.azure.resourcemanager.appservice.models.WorkflowProvisioningState;
import com.azure.resourcemanager.appservice.models.WorkflowSku;
import com.azure.resourcemanager.appservice.models.WorkflowState;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Map;

/**
 * The workflow version properties.
 */
@Fluent
public final class WorkflowVersionProperties implements JsonSerializable<WorkflowVersionProperties> {
    /*
     * The provisioning state.
     */
    private WorkflowProvisioningState provisioningState;

    /*
     * Gets the created time.
     */
    private OffsetDateTime createdTime;

    /*
     * Gets the changed time.
     */
    private OffsetDateTime changedTime;

    /*
     * The state.
     */
    private WorkflowState state;

    /*
     * Gets the version.
     */
    private String version;

    /*
     * Gets the access endpoint.
     */
    private String accessEndpoint;

    /*
     * The endpoints configuration.
     */
    private FlowEndpointsConfiguration endpointsConfiguration;

    /*
     * The access control configuration.
     */
    private FlowAccessControlConfiguration accessControl;

    /*
     * The sku.
     */
    private WorkflowSku sku;

    /*
     * The integration account.
     */
    private ResourceReference integrationAccount;

    /*
     * The definition.
     */
    private Object definition;

    /*
     * The parameters.
     */
    private Map<String, WorkflowParameter> parameters;

    /**
     * Creates an instance of WorkflowVersionProperties class.
     */
    public WorkflowVersionProperties() {
    }

    /**
     * Get the provisioningState property: The provisioning state.
     * 
     * @return the provisioningState value.
     */
    public WorkflowProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the createdTime property: Gets the created time.
     * 
     * @return the createdTime value.
     */
    public OffsetDateTime createdTime() {
        return this.createdTime;
    }

    /**
     * Get the changedTime property: Gets the changed time.
     * 
     * @return the changedTime value.
     */
    public OffsetDateTime changedTime() {
        return this.changedTime;
    }

    /**
     * Get the state property: The state.
     * 
     * @return the state value.
     */
    public WorkflowState state() {
        return this.state;
    }

    /**
     * Set the state property: The state.
     * 
     * @param state the state value to set.
     * @return the WorkflowVersionProperties object itself.
     */
    public WorkflowVersionProperties withState(WorkflowState state) {
        this.state = state;
        return this;
    }

    /**
     * Get the version property: Gets the version.
     * 
     * @return the version value.
     */
    public String version() {
        return this.version;
    }

    /**
     * Get the accessEndpoint property: Gets the access endpoint.
     * 
     * @return the accessEndpoint value.
     */
    public String accessEndpoint() {
        return this.accessEndpoint;
    }

    /**
     * Get the endpointsConfiguration property: The endpoints configuration.
     * 
     * @return the endpointsConfiguration value.
     */
    public FlowEndpointsConfiguration endpointsConfiguration() {
        return this.endpointsConfiguration;
    }

    /**
     * Set the endpointsConfiguration property: The endpoints configuration.
     * 
     * @param endpointsConfiguration the endpointsConfiguration value to set.
     * @return the WorkflowVersionProperties object itself.
     */
    public WorkflowVersionProperties withEndpointsConfiguration(FlowEndpointsConfiguration endpointsConfiguration) {
        this.endpointsConfiguration = endpointsConfiguration;
        return this;
    }

    /**
     * Get the accessControl property: The access control configuration.
     * 
     * @return the accessControl value.
     */
    public FlowAccessControlConfiguration accessControl() {
        return this.accessControl;
    }

    /**
     * Set the accessControl property: The access control configuration.
     * 
     * @param accessControl the accessControl value to set.
     * @return the WorkflowVersionProperties object itself.
     */
    public WorkflowVersionProperties withAccessControl(FlowAccessControlConfiguration accessControl) {
        this.accessControl = accessControl;
        return this;
    }

    /**
     * Get the sku property: The sku.
     * 
     * @return the sku value.
     */
    public WorkflowSku sku() {
        return this.sku;
    }

    /**
     * Get the integrationAccount property: The integration account.
     * 
     * @return the integrationAccount value.
     */
    public ResourceReference integrationAccount() {
        return this.integrationAccount;
    }

    /**
     * Set the integrationAccount property: The integration account.
     * 
     * @param integrationAccount the integrationAccount value to set.
     * @return the WorkflowVersionProperties object itself.
     */
    public WorkflowVersionProperties withIntegrationAccount(ResourceReference integrationAccount) {
        this.integrationAccount = integrationAccount;
        return this;
    }

    /**
     * Get the definition property: The definition.
     * 
     * @return the definition value.
     */
    public Object definition() {
        return this.definition;
    }

    /**
     * Set the definition property: The definition.
     * 
     * @param definition the definition value to set.
     * @return the WorkflowVersionProperties object itself.
     */
    public WorkflowVersionProperties withDefinition(Object definition) {
        this.definition = definition;
        return this;
    }

    /**
     * Get the parameters property: The parameters.
     * 
     * @return the parameters value.
     */
    public Map<String, WorkflowParameter> parameters() {
        return this.parameters;
    }

    /**
     * Set the parameters property: The parameters.
     * 
     * @param parameters the parameters value to set.
     * @return the WorkflowVersionProperties object itself.
     */
    public WorkflowVersionProperties withParameters(Map<String, WorkflowParameter> parameters) {
        this.parameters = parameters;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (endpointsConfiguration() != null) {
            endpointsConfiguration().validate();
        }
        if (accessControl() != null) {
            accessControl().validate();
        }
        if (sku() != null) {
            sku().validate();
        }
        if (integrationAccount() != null) {
            integrationAccount().validate();
        }
        if (parameters() != null) {
            parameters().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("state", this.state == null ? null : this.state.toString());
        jsonWriter.writeJsonField("endpointsConfiguration", this.endpointsConfiguration);
        jsonWriter.writeJsonField("accessControl", this.accessControl);
        jsonWriter.writeJsonField("integrationAccount", this.integrationAccount);
        if (this.definition != null) {
            jsonWriter.writeUntypedField("definition", this.definition);
        }
        jsonWriter.writeMapField("parameters", this.parameters, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of WorkflowVersionProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of WorkflowVersionProperties if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the WorkflowVersionProperties.
     */
    public static WorkflowVersionProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            WorkflowVersionProperties deserializedWorkflowVersionProperties = new WorkflowVersionProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("provisioningState".equals(fieldName)) {
                    deserializedWorkflowVersionProperties.provisioningState
                        = WorkflowProvisioningState.fromString(reader.getString());
                } else if ("createdTime".equals(fieldName)) {
                    deserializedWorkflowVersionProperties.createdTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("changedTime".equals(fieldName)) {
                    deserializedWorkflowVersionProperties.changedTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("state".equals(fieldName)) {
                    deserializedWorkflowVersionProperties.state = WorkflowState.fromString(reader.getString());
                } else if ("version".equals(fieldName)) {
                    deserializedWorkflowVersionProperties.version = reader.getString();
                } else if ("accessEndpoint".equals(fieldName)) {
                    deserializedWorkflowVersionProperties.accessEndpoint = reader.getString();
                } else if ("endpointsConfiguration".equals(fieldName)) {
                    deserializedWorkflowVersionProperties.endpointsConfiguration
                        = FlowEndpointsConfiguration.fromJson(reader);
                } else if ("accessControl".equals(fieldName)) {
                    deserializedWorkflowVersionProperties.accessControl
                        = FlowAccessControlConfiguration.fromJson(reader);
                } else if ("sku".equals(fieldName)) {
                    deserializedWorkflowVersionProperties.sku = WorkflowSku.fromJson(reader);
                } else if ("integrationAccount".equals(fieldName)) {
                    deserializedWorkflowVersionProperties.integrationAccount = ResourceReference.fromJson(reader);
                } else if ("definition".equals(fieldName)) {
                    deserializedWorkflowVersionProperties.definition = reader.readUntyped();
                } else if ("parameters".equals(fieldName)) {
                    Map<String, WorkflowParameter> parameters
                        = reader.readMap(reader1 -> WorkflowParameter.fromJson(reader1));
                    deserializedWorkflowVersionProperties.parameters = parameters;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedWorkflowVersionProperties;
        });
    }
}
