// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

/**
 * Domain purchase consent object, representing acceptance of applicable legal agreements.
 */
@Fluent
public final class DomainPurchaseConsent implements JsonSerializable<DomainPurchaseConsent> {
    /*
     * List of applicable legal agreement keys. This list can be retrieved using ListLegalAgreements API under
     * <code>TopLevelDomain</code> resource.
     */
    private List<String> agreementKeys;

    /*
     * Client IP address.
     */
    private String agreedBy;

    /*
     * Timestamp when the agreements were accepted.
     */
    private OffsetDateTime agreedAt;

    /**
     * Creates an instance of DomainPurchaseConsent class.
     */
    public DomainPurchaseConsent() {
    }

    /**
     * Get the agreementKeys property: List of applicable legal agreement keys. This list can be retrieved using
     * ListLegalAgreements API under &lt;code&gt;TopLevelDomain&lt;/code&gt; resource.
     * 
     * @return the agreementKeys value.
     */
    public List<String> agreementKeys() {
        return this.agreementKeys;
    }

    /**
     * Set the agreementKeys property: List of applicable legal agreement keys. This list can be retrieved using
     * ListLegalAgreements API under &lt;code&gt;TopLevelDomain&lt;/code&gt; resource.
     * 
     * @param agreementKeys the agreementKeys value to set.
     * @return the DomainPurchaseConsent object itself.
     */
    public DomainPurchaseConsent withAgreementKeys(List<String> agreementKeys) {
        this.agreementKeys = agreementKeys;
        return this;
    }

    /**
     * Get the agreedBy property: Client IP address.
     * 
     * @return the agreedBy value.
     */
    public String agreedBy() {
        return this.agreedBy;
    }

    /**
     * Set the agreedBy property: Client IP address.
     * 
     * @param agreedBy the agreedBy value to set.
     * @return the DomainPurchaseConsent object itself.
     */
    public DomainPurchaseConsent withAgreedBy(String agreedBy) {
        this.agreedBy = agreedBy;
        return this;
    }

    /**
     * Get the agreedAt property: Timestamp when the agreements were accepted.
     * 
     * @return the agreedAt value.
     */
    public OffsetDateTime agreedAt() {
        return this.agreedAt;
    }

    /**
     * Set the agreedAt property: Timestamp when the agreements were accepted.
     * 
     * @param agreedAt the agreedAt value to set.
     * @return the DomainPurchaseConsent object itself.
     */
    public DomainPurchaseConsent withAgreedAt(OffsetDateTime agreedAt) {
        this.agreedAt = agreedAt;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("agreementKeys", this.agreementKeys,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("agreedBy", this.agreedBy);
        jsonWriter.writeStringField("agreedAt",
            this.agreedAt == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.agreedAt));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DomainPurchaseConsent from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DomainPurchaseConsent if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DomainPurchaseConsent.
     */
    public static DomainPurchaseConsent fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DomainPurchaseConsent deserializedDomainPurchaseConsent = new DomainPurchaseConsent();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("agreementKeys".equals(fieldName)) {
                    List<String> agreementKeys = reader.readArray(reader1 -> reader1.getString());
                    deserializedDomainPurchaseConsent.agreementKeys = agreementKeys;
                } else if ("agreedBy".equals(fieldName)) {
                    deserializedDomainPurchaseConsent.agreedBy = reader.getString();
                } else if ("agreedAt".equals(fieldName)) {
                    deserializedDomainPurchaseConsent.agreedAt = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDomainPurchaseConsent;
        });
    }
}
