// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The ip address.
 */
@Fluent
public final class IpAddress implements JsonSerializable<IpAddress> {
    /*
     * The address.
     */
    private String address;

    /**
     * Creates an instance of IpAddress class.
     */
    public IpAddress() {
    }

    /**
     * Get the address property: The address.
     * 
     * @return the address value.
     */
    public String address() {
        return this.address;
    }

    /**
     * Set the address property: The address.
     * 
     * @param address the address value to set.
     * @return the IpAddress object itself.
     */
    public IpAddress withAddress(String address) {
        this.address = address;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("address", this.address);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of IpAddress from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of IpAddress if the JsonReader was pointing to an instance of it, or null if it was pointing
     * to JSON null.
     * @throws IOException If an error occurs while reading the IpAddress.
     */
    public static IpAddress fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            IpAddress deserializedIpAddress = new IpAddress();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("address".equals(fieldName)) {
                    deserializedIpAddress.address = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedIpAddress;
        });
    }
}
