// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

/**
 * Specifies the IP mode of the app.
 */
public enum IpMode {
    /**
     * Enum value IPv4.
     */
    IPV4("IPv4"),

    /**
     * Enum value IPv6.
     */
    IPV6("IPv6"),

    /**
     * Enum value IPv4AndIPv6.
     */
    IPV4AND_IPV6("IPv4AndIPv6");

    /**
     * The actual serialized value for a IpMode instance.
     */
    private final String value;

    IpMode(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a IpMode instance.
     * 
     * @param value the serialized value to parse.
     * @return the parsed IpMode object, or null if unable to parse.
     */
    public static IpMode fromString(String value) {
        if (value == null) {
            return null;
        }
        IpMode[] items = IpMode.values();
        for (IpMode item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String toString() {
        return this.value;
    }
}
