/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.ErrorInfo;
import java.io.IOException;
import java.util.List;

public final class AzureResourceErrorInfo
extends ErrorInfo {
    private String message;
    private List<AzureResourceErrorInfo> details;
    private static final ClientLogger LOGGER = new ClientLogger(AzureResourceErrorInfo.class);

    public String message() {
        return this.message;
    }

    public AzureResourceErrorInfo withMessage(String message) {
        this.message = message;
        return this;
    }

    public List<AzureResourceErrorInfo> details() {
        return this.details;
    }

    public AzureResourceErrorInfo withDetails(List<AzureResourceErrorInfo> details) {
        this.details = details;
        return this;
    }

    @Override
    public AzureResourceErrorInfo withCode(String code) {
        super.withCode(code);
        return this;
    }

    @Override
    public void validate() {
        if (this.message() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property message in model AzureResourceErrorInfo"));
        }
        if (this.details() != null) {
            this.details().forEach(e -> e.validate());
        }
        if (this.code() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property code in model AzureResourceErrorInfo"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("code", this.code());
        jsonWriter.writeStringField("message", this.message);
        jsonWriter.writeArrayField("details", this.details, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static AzureResourceErrorInfo fromJson(JsonReader jsonReader) throws IOException {
        return (AzureResourceErrorInfo)jsonReader.readObject(reader -> {
            AzureResourceErrorInfo deserializedAzureResourceErrorInfo = new AzureResourceErrorInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("code".equals(fieldName)) {
                    deserializedAzureResourceErrorInfo.withCode(reader.getString());
                    continue;
                }
                if ("message".equals(fieldName)) {
                    deserializedAzureResourceErrorInfo.message = reader.getString();
                    continue;
                }
                if ("details".equals(fieldName)) {
                    List details;
                    deserializedAzureResourceErrorInfo.details = details = reader.readArray(reader1 -> AzureResourceErrorInfo.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAzureResourceErrorInfo;
        });
    }
}

