// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * DeletedSite resource specific properties.
 */
@Immutable
public final class DeletedSiteProperties implements JsonSerializable<DeletedSiteProperties> {
    /*
     * Numeric id for the deleted site
     */
    private Integer deletedSiteId;

    /*
     * Time in UTC when the app was deleted.
     */
    private String deletedTimestamp;

    /*
     * Subscription containing the deleted site
     */
    private String subscription;

    /*
     * ResourceGroup that contained the deleted site
     */
    private String resourceGroup;

    /*
     * Name of the deleted site
     */
    private String deletedSiteName;

    /*
     * Slot of the deleted site
     */
    private String slot;

    /*
     * Kind of site that was deleted
     */
    private String kind;

    /*
     * Geo Region of the deleted site
     */
    private String geoRegionName;

    /**
     * Creates an instance of DeletedSiteProperties class.
     */
    public DeletedSiteProperties() {
    }

    /**
     * Get the deletedSiteId property: Numeric id for the deleted site.
     * 
     * @return the deletedSiteId value.
     */
    public Integer deletedSiteId() {
        return this.deletedSiteId;
    }

    /**
     * Get the deletedTimestamp property: Time in UTC when the app was deleted.
     * 
     * @return the deletedTimestamp value.
     */
    public String deletedTimestamp() {
        return this.deletedTimestamp;
    }

    /**
     * Get the subscription property: Subscription containing the deleted site.
     * 
     * @return the subscription value.
     */
    public String subscription() {
        return this.subscription;
    }

    /**
     * Get the resourceGroup property: ResourceGroup that contained the deleted site.
     * 
     * @return the resourceGroup value.
     */
    public String resourceGroup() {
        return this.resourceGroup;
    }

    /**
     * Get the deletedSiteName property: Name of the deleted site.
     * 
     * @return the deletedSiteName value.
     */
    public String deletedSiteName() {
        return this.deletedSiteName;
    }

    /**
     * Get the slot property: Slot of the deleted site.
     * 
     * @return the slot value.
     */
    public String slot() {
        return this.slot;
    }

    /**
     * Get the kind property: Kind of site that was deleted.
     * 
     * @return the kind value.
     */
    public String kind() {
        return this.kind;
    }

    /**
     * Get the geoRegionName property: Geo Region of the deleted site.
     * 
     * @return the geoRegionName value.
     */
    public String geoRegionName() {
        return this.geoRegionName;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DeletedSiteProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DeletedSiteProperties if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DeletedSiteProperties.
     */
    public static DeletedSiteProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DeletedSiteProperties deserializedDeletedSiteProperties = new DeletedSiteProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("deletedSiteId".equals(fieldName)) {
                    deserializedDeletedSiteProperties.deletedSiteId = reader.getNullable(JsonReader::getInt);
                } else if ("deletedTimestamp".equals(fieldName)) {
                    deserializedDeletedSiteProperties.deletedTimestamp = reader.getString();
                } else if ("subscription".equals(fieldName)) {
                    deserializedDeletedSiteProperties.subscription = reader.getString();
                } else if ("resourceGroup".equals(fieldName)) {
                    deserializedDeletedSiteProperties.resourceGroup = reader.getString();
                } else if ("deletedSiteName".equals(fieldName)) {
                    deserializedDeletedSiteProperties.deletedSiteName = reader.getString();
                } else if ("slot".equals(fieldName)) {
                    deserializedDeletedSiteProperties.slot = reader.getString();
                } else if ("kind".equals(fieldName)) {
                    deserializedDeletedSiteProperties.kind = reader.getString();
                } else if ("geoRegionName".equals(fieldName)) {
                    deserializedDeletedSiteProperties.geoRegionName = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDeletedSiteProperties;
        });
    }
}
