// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The ContainerCpuStatistics model.
 */
@Fluent
public final class ContainerCpuStatistics implements JsonSerializable<ContainerCpuStatistics> {
    /*
     * The cpuUsage property.
     */
    private ContainerCpuUsage cpuUsage;

    /*
     * The systemCpuUsage property.
     */
    private Long systemCpuUsage;

    /*
     * The onlineCpuCount property.
     */
    private Integer onlineCpuCount;

    /*
     * The throttlingData property.
     */
    private ContainerThrottlingData throttlingData;

    /**
     * Creates an instance of ContainerCpuStatistics class.
     */
    public ContainerCpuStatistics() {
    }

    /**
     * Get the cpuUsage property: The cpuUsage property.
     * 
     * @return the cpuUsage value.
     */
    public ContainerCpuUsage cpuUsage() {
        return this.cpuUsage;
    }

    /**
     * Set the cpuUsage property: The cpuUsage property.
     * 
     * @param cpuUsage the cpuUsage value to set.
     * @return the ContainerCpuStatistics object itself.
     */
    public ContainerCpuStatistics withCpuUsage(ContainerCpuUsage cpuUsage) {
        this.cpuUsage = cpuUsage;
        return this;
    }

    /**
     * Get the systemCpuUsage property: The systemCpuUsage property.
     * 
     * @return the systemCpuUsage value.
     */
    public Long systemCpuUsage() {
        return this.systemCpuUsage;
    }

    /**
     * Set the systemCpuUsage property: The systemCpuUsage property.
     * 
     * @param systemCpuUsage the systemCpuUsage value to set.
     * @return the ContainerCpuStatistics object itself.
     */
    public ContainerCpuStatistics withSystemCpuUsage(Long systemCpuUsage) {
        this.systemCpuUsage = systemCpuUsage;
        return this;
    }

    /**
     * Get the onlineCpuCount property: The onlineCpuCount property.
     * 
     * @return the onlineCpuCount value.
     */
    public Integer onlineCpuCount() {
        return this.onlineCpuCount;
    }

    /**
     * Set the onlineCpuCount property: The onlineCpuCount property.
     * 
     * @param onlineCpuCount the onlineCpuCount value to set.
     * @return the ContainerCpuStatistics object itself.
     */
    public ContainerCpuStatistics withOnlineCpuCount(Integer onlineCpuCount) {
        this.onlineCpuCount = onlineCpuCount;
        return this;
    }

    /**
     * Get the throttlingData property: The throttlingData property.
     * 
     * @return the throttlingData value.
     */
    public ContainerThrottlingData throttlingData() {
        return this.throttlingData;
    }

    /**
     * Set the throttlingData property: The throttlingData property.
     * 
     * @param throttlingData the throttlingData value to set.
     * @return the ContainerCpuStatistics object itself.
     */
    public ContainerCpuStatistics withThrottlingData(ContainerThrottlingData throttlingData) {
        this.throttlingData = throttlingData;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (cpuUsage() != null) {
            cpuUsage().validate();
        }
        if (throttlingData() != null) {
            throttlingData().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("cpuUsage", this.cpuUsage);
        jsonWriter.writeNumberField("systemCpuUsage", this.systemCpuUsage);
        jsonWriter.writeNumberField("onlineCpuCount", this.onlineCpuCount);
        jsonWriter.writeJsonField("throttlingData", this.throttlingData);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ContainerCpuStatistics from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ContainerCpuStatistics if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ContainerCpuStatistics.
     */
    public static ContainerCpuStatistics fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ContainerCpuStatistics deserializedContainerCpuStatistics = new ContainerCpuStatistics();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("cpuUsage".equals(fieldName)) {
                    deserializedContainerCpuStatistics.cpuUsage = ContainerCpuUsage.fromJson(reader);
                } else if ("systemCpuUsage".equals(fieldName)) {
                    deserializedContainerCpuStatistics.systemCpuUsage = reader.getNullable(JsonReader::getLong);
                } else if ("onlineCpuCount".equals(fieldName)) {
                    deserializedContainerCpuStatistics.onlineCpuCount = reader.getNullable(JsonReader::getInt);
                } else if ("throttlingData".equals(fieldName)) {
                    deserializedContainerCpuStatistics.throttlingData = ContainerThrottlingData.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedContainerCpuStatistics;
        });
    }
}
