// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The ContainerThrottlingData model.
 */
@Fluent
public final class ContainerThrottlingData implements JsonSerializable<ContainerThrottlingData> {
    /*
     * The periods property.
     */
    private Integer periods;

    /*
     * The throttledPeriods property.
     */
    private Integer throttledPeriods;

    /*
     * The throttledTime property.
     */
    private Integer throttledTime;

    /**
     * Creates an instance of ContainerThrottlingData class.
     */
    public ContainerThrottlingData() {
    }

    /**
     * Get the periods property: The periods property.
     * 
     * @return the periods value.
     */
    public Integer periods() {
        return this.periods;
    }

    /**
     * Set the periods property: The periods property.
     * 
     * @param periods the periods value to set.
     * @return the ContainerThrottlingData object itself.
     */
    public ContainerThrottlingData withPeriods(Integer periods) {
        this.periods = periods;
        return this;
    }

    /**
     * Get the throttledPeriods property: The throttledPeriods property.
     * 
     * @return the throttledPeriods value.
     */
    public Integer throttledPeriods() {
        return this.throttledPeriods;
    }

    /**
     * Set the throttledPeriods property: The throttledPeriods property.
     * 
     * @param throttledPeriods the throttledPeriods value to set.
     * @return the ContainerThrottlingData object itself.
     */
    public ContainerThrottlingData withThrottledPeriods(Integer throttledPeriods) {
        this.throttledPeriods = throttledPeriods;
        return this;
    }

    /**
     * Get the throttledTime property: The throttledTime property.
     * 
     * @return the throttledTime value.
     */
    public Integer throttledTime() {
        return this.throttledTime;
    }

    /**
     * Set the throttledTime property: The throttledTime property.
     * 
     * @param throttledTime the throttledTime value to set.
     * @return the ContainerThrottlingData object itself.
     */
    public ContainerThrottlingData withThrottledTime(Integer throttledTime) {
        this.throttledTime = throttledTime;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("periods", this.periods);
        jsonWriter.writeNumberField("throttledPeriods", this.throttledPeriods);
        jsonWriter.writeNumberField("throttledTime", this.throttledTime);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ContainerThrottlingData from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ContainerThrottlingData if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ContainerThrottlingData.
     */
    public static ContainerThrottlingData fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ContainerThrottlingData deserializedContainerThrottlingData = new ContainerThrottlingData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("periods".equals(fieldName)) {
                    deserializedContainerThrottlingData.periods = reader.getNullable(JsonReader::getInt);
                } else if ("throttledPeriods".equals(fieldName)) {
                    deserializedContainerThrottlingData.throttledPeriods = reader.getNullable(JsonReader::getInt);
                } else if ("throttledTime".equals(fieldName)) {
                    deserializedContainerThrottlingData.throttledTime = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedContainerThrottlingData;
        });
    }
}
