// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Result for utterances query.
 */
@Fluent
public final class QueryUtterancesResult implements JsonSerializable<QueryUtterancesResult> {
    /*
     * A sample utterance.
     */
    private SampleUtterance sampleUtterance;

    /*
     * Score of a sample utterance.
     */
    private Float score;

    /**
     * Creates an instance of QueryUtterancesResult class.
     */
    public QueryUtterancesResult() {
    }

    /**
     * Get the sampleUtterance property: A sample utterance.
     * 
     * @return the sampleUtterance value.
     */
    public SampleUtterance sampleUtterance() {
        return this.sampleUtterance;
    }

    /**
     * Set the sampleUtterance property: A sample utterance.
     * 
     * @param sampleUtterance the sampleUtterance value to set.
     * @return the QueryUtterancesResult object itself.
     */
    public QueryUtterancesResult withSampleUtterance(SampleUtterance sampleUtterance) {
        this.sampleUtterance = sampleUtterance;
        return this;
    }

    /**
     * Get the score property: Score of a sample utterance.
     * 
     * @return the score value.
     */
    public Float score() {
        return this.score;
    }

    /**
     * Set the score property: Score of a sample utterance.
     * 
     * @param score the score value to set.
     * @return the QueryUtterancesResult object itself.
     */
    public QueryUtterancesResult withScore(Float score) {
        this.score = score;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (sampleUtterance() != null) {
            sampleUtterance().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("sampleUtterance", this.sampleUtterance);
        jsonWriter.writeNumberField("score", this.score);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of QueryUtterancesResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of QueryUtterancesResult if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the QueryUtterancesResult.
     */
    public static QueryUtterancesResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            QueryUtterancesResult deserializedQueryUtterancesResult = new QueryUtterancesResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("sampleUtterance".equals(fieldName)) {
                    deserializedQueryUtterancesResult.sampleUtterance = SampleUtterance.fromJson(reader);
                } else if ("score".equals(fieldName)) {
                    deserializedQueryUtterancesResult.score = reader.getNullable(JsonReader::getFloat);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedQueryUtterancesResult;
        });
    }
}
