// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Suggested utterances where the detector can be applicable.
 */
@Fluent
public final class QueryUtterancesResults implements JsonSerializable<QueryUtterancesResults> {
    /*
     * Search Query.
     */
    private String query;

    /*
     * Array of utterance results for search query.
     */
    private List<QueryUtterancesResult> results;

    /**
     * Creates an instance of QueryUtterancesResults class.
     */
    public QueryUtterancesResults() {
    }

    /**
     * Get the query property: Search Query.
     * 
     * @return the query value.
     */
    public String query() {
        return this.query;
    }

    /**
     * Set the query property: Search Query.
     * 
     * @param query the query value to set.
     * @return the QueryUtterancesResults object itself.
     */
    public QueryUtterancesResults withQuery(String query) {
        this.query = query;
        return this;
    }

    /**
     * Get the results property: Array of utterance results for search query.
     * 
     * @return the results value.
     */
    public List<QueryUtterancesResult> results() {
        return this.results;
    }

    /**
     * Set the results property: Array of utterance results for search query.
     * 
     * @param results the results value to set.
     * @return the QueryUtterancesResults object itself.
     */
    public QueryUtterancesResults withResults(List<QueryUtterancesResult> results) {
        this.results = results;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (results() != null) {
            results().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("query", this.query);
        jsonWriter.writeArrayField("results", this.results, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of QueryUtterancesResults from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of QueryUtterancesResults if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the QueryUtterancesResults.
     */
    public static QueryUtterancesResults fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            QueryUtterancesResults deserializedQueryUtterancesResults = new QueryUtterancesResults();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("query".equals(fieldName)) {
                    deserializedQueryUtterancesResults.query = reader.getString();
                } else if ("results".equals(fieldName)) {
                    List<QueryUtterancesResult> results
                        = reader.readArray(reader1 -> QueryUtterancesResult.fromJson(reader1));
                    deserializedQueryUtterancesResults.results = results;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedQueryUtterancesResults;
        });
    }
}
