// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The recurrence schedule.
 */
@Fluent
public final class RecurrenceSchedule implements JsonSerializable<RecurrenceSchedule> {
    /*
     * The minutes.
     */
    private List<Integer> minutes;

    /*
     * The hours.
     */
    private List<Integer> hours;

    /*
     * The days of the week.
     */
    private List<DaysOfWeek> weekDays;

    /*
     * The month days.
     */
    private List<Integer> monthDays;

    /*
     * The monthly occurrences.
     */
    private List<RecurrenceScheduleOccurrence> monthlyOccurrences;

    /**
     * Creates an instance of RecurrenceSchedule class.
     */
    public RecurrenceSchedule() {
    }

    /**
     * Get the minutes property: The minutes.
     * 
     * @return the minutes value.
     */
    public List<Integer> minutes() {
        return this.minutes;
    }

    /**
     * Set the minutes property: The minutes.
     * 
     * @param minutes the minutes value to set.
     * @return the RecurrenceSchedule object itself.
     */
    public RecurrenceSchedule withMinutes(List<Integer> minutes) {
        this.minutes = minutes;
        return this;
    }

    /**
     * Get the hours property: The hours.
     * 
     * @return the hours value.
     */
    public List<Integer> hours() {
        return this.hours;
    }

    /**
     * Set the hours property: The hours.
     * 
     * @param hours the hours value to set.
     * @return the RecurrenceSchedule object itself.
     */
    public RecurrenceSchedule withHours(List<Integer> hours) {
        this.hours = hours;
        return this;
    }

    /**
     * Get the weekDays property: The days of the week.
     * 
     * @return the weekDays value.
     */
    public List<DaysOfWeek> weekDays() {
        return this.weekDays;
    }

    /**
     * Set the weekDays property: The days of the week.
     * 
     * @param weekDays the weekDays value to set.
     * @return the RecurrenceSchedule object itself.
     */
    public RecurrenceSchedule withWeekDays(List<DaysOfWeek> weekDays) {
        this.weekDays = weekDays;
        return this;
    }

    /**
     * Get the monthDays property: The month days.
     * 
     * @return the monthDays value.
     */
    public List<Integer> monthDays() {
        return this.monthDays;
    }

    /**
     * Set the monthDays property: The month days.
     * 
     * @param monthDays the monthDays value to set.
     * @return the RecurrenceSchedule object itself.
     */
    public RecurrenceSchedule withMonthDays(List<Integer> monthDays) {
        this.monthDays = monthDays;
        return this;
    }

    /**
     * Get the monthlyOccurrences property: The monthly occurrences.
     * 
     * @return the monthlyOccurrences value.
     */
    public List<RecurrenceScheduleOccurrence> monthlyOccurrences() {
        return this.monthlyOccurrences;
    }

    /**
     * Set the monthlyOccurrences property: The monthly occurrences.
     * 
     * @param monthlyOccurrences the monthlyOccurrences value to set.
     * @return the RecurrenceSchedule object itself.
     */
    public RecurrenceSchedule withMonthlyOccurrences(List<RecurrenceScheduleOccurrence> monthlyOccurrences) {
        this.monthlyOccurrences = monthlyOccurrences;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (monthlyOccurrences() != null) {
            monthlyOccurrences().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("minutes", this.minutes, (writer, element) -> writer.writeInt(element));
        jsonWriter.writeArrayField("hours", this.hours, (writer, element) -> writer.writeInt(element));
        jsonWriter.writeArrayField("weekDays", this.weekDays,
            (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeArrayField("monthDays", this.monthDays, (writer, element) -> writer.writeInt(element));
        jsonWriter.writeArrayField("monthlyOccurrences", this.monthlyOccurrences,
            (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RecurrenceSchedule from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RecurrenceSchedule if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the RecurrenceSchedule.
     */
    public static RecurrenceSchedule fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RecurrenceSchedule deserializedRecurrenceSchedule = new RecurrenceSchedule();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("minutes".equals(fieldName)) {
                    List<Integer> minutes = reader.readArray(reader1 -> reader1.getInt());
                    deserializedRecurrenceSchedule.minutes = minutes;
                } else if ("hours".equals(fieldName)) {
                    List<Integer> hours = reader.readArray(reader1 -> reader1.getInt());
                    deserializedRecurrenceSchedule.hours = hours;
                } else if ("weekDays".equals(fieldName)) {
                    List<DaysOfWeek> weekDays = reader.readArray(reader1 -> DaysOfWeek.fromString(reader1.getString()));
                    deserializedRecurrenceSchedule.weekDays = weekDays;
                } else if ("monthDays".equals(fieldName)) {
                    List<Integer> monthDays = reader.readArray(reader1 -> reader1.getInt());
                    deserializedRecurrenceSchedule.monthDays = monthDays;
                } else if ("monthlyOccurrences".equals(fieldName)) {
                    List<RecurrenceScheduleOccurrence> monthlyOccurrences
                        = reader.readArray(reader1 -> RecurrenceScheduleOccurrence.fromJson(reader1));
                    deserializedRecurrenceSchedule.monthlyOccurrences = monthlyOccurrences;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRecurrenceSchedule;
        });
    }
}
