/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.InstallScriptSource;
import java.io.IOException;

public final class InstallScript
implements JsonSerializable<InstallScript> {
    private String name;
    private InstallScriptSource source;

    public String name() {
        return this.name;
    }

    public InstallScript withName(String name) {
        this.name = name;
        return this;
    }

    public InstallScriptSource source() {
        return this.source;
    }

    public InstallScript withSource(InstallScriptSource source) {
        this.source = source;
        return this;
    }

    public void validate() {
        if (this.source() != null) {
            this.source().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeJsonField("source", (JsonSerializable)this.source);
        return jsonWriter.writeEndObject();
    }

    public static InstallScript fromJson(JsonReader jsonReader) throws IOException {
        return (InstallScript)jsonReader.readObject(reader -> {
            InstallScript deserializedInstallScript = new InstallScript();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedInstallScript.name = reader.getString();
                    continue;
                }
                if ("source".equals(fieldName)) {
                    deserializedInstallScript.source = InstallScriptSource.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedInstallScript;
        });
    }
}

