/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.InstallScriptType;
import java.io.IOException;

public final class InstallScriptSource
implements JsonSerializable<InstallScriptSource> {
    private String sourceUri;
    private InstallScriptType type;

    public String sourceUri() {
        return this.sourceUri;
    }

    public InstallScriptSource withSourceUri(String sourceUri) {
        this.sourceUri = sourceUri;
        return this;
    }

    public InstallScriptType type() {
        return this.type;
    }

    public InstallScriptSource withType(InstallScriptType type) {
        this.type = type;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("sourceUri", this.sourceUri);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    public static InstallScriptSource fromJson(JsonReader jsonReader) throws IOException {
        return (InstallScriptSource)jsonReader.readObject(reader -> {
            InstallScriptSource deserializedInstallScriptSource = new InstallScriptSource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourceUri".equals(fieldName)) {
                    deserializedInstallScriptSource.sourceUri = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedInstallScriptSource.type = InstallScriptType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedInstallScriptSource;
        });
    }
}

