// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Function secrets. */
@Fluent
public final class FunctionSecretsInner {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(FunctionSecretsInner.class);

    /*
     * Secret key.
     */
    @JsonProperty(value = "key")
    private String key;

    /*
     * Trigger URL.
     */
    @JsonProperty(value = "trigger_url")
    private String triggerUrl;

    /**
     * Get the key property: Secret key.
     *
     * @return the key value.
     */
    public String key() {
        return this.key;
    }

    /**
     * Set the key property: Secret key.
     *
     * @param key the key value to set.
     * @return the FunctionSecretsInner object itself.
     */
    public FunctionSecretsInner withKey(String key) {
        this.key = key;
        return this;
    }

    /**
     * Get the triggerUrl property: Trigger URL.
     *
     * @return the triggerUrl value.
     */
    public String triggerUrl() {
        return this.triggerUrl;
    }

    /**
     * Set the triggerUrl property: Trigger URL.
     *
     * @param triggerUrl the triggerUrl value to set.
     * @return the FunctionSecretsInner object itself.
     */
    public FunctionSecretsInner withTriggerUrl(String triggerUrl) {
        this.triggerUrl = triggerUrl;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
