// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appservice.models.MSDeployLogEntry;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** MSDeployLog resource specific properties. */
@Immutable
public final class MSDeployLogProperties {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(MSDeployLogProperties.class);

    /*
     * List of log entry messages
     */
    @JsonProperty(value = "entries", access = JsonProperty.Access.WRITE_ONLY)
    private List<MSDeployLogEntry> entries;

    /**
     * Get the entries property: List of log entry messages.
     *
     * @return the entries value.
     */
    public List<MSDeployLogEntry> entries() {
        return this.entries;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (entries() != null) {
            entries().forEach(e -> e.validate());
        }
    }
}
