// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Database connection string information. */
@Fluent
public final class ConnStringInfo {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(ConnStringInfo.class);

    /*
     * Name of connection string.
     */
    @JsonProperty(value = "name")
    private String name;

    /*
     * Connection string value.
     */
    @JsonProperty(value = "connectionString")
    private String connectionString;

    /*
     * Type of database.
     */
    @JsonProperty(value = "type")
    private ConnectionStringType type;

    /**
     * Get the name property: Name of connection string.
     *
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Name of connection string.
     *
     * @param name the name value to set.
     * @return the ConnStringInfo object itself.
     */
    public ConnStringInfo withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the connectionString property: Connection string value.
     *
     * @return the connectionString value.
     */
    public String connectionString() {
        return this.connectionString;
    }

    /**
     * Set the connectionString property: Connection string value.
     *
     * @param connectionString the connectionString value to set.
     * @return the ConnStringInfo object itself.
     */
    public ConnStringInfo withConnectionString(String connectionString) {
        this.connectionString = connectionString;
        return this;
    }

    /**
     * Get the type property: Type of database.
     *
     * @return the type value.
     */
    public ConnectionStringType type() {
        return this.type;
    }

    /**
     * Set the type property: Type of database.
     *
     * @param type the type value to set.
     * @return the ConnStringInfo object itself.
     */
    public ConnStringInfo withType(ConnectionStringType type) {
        this.type = type;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
