// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Identify the status of the most severe insight generated by the detector. */
@Fluent
public final class Status {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(Status.class);

    /*
     * Descriptive message.
     */
    @JsonProperty(value = "message")
    private String message;

    /*
     * Level of the most severe insight generated by the detector.
     */
    @JsonProperty(value = "statusId")
    private InsightStatus statusId;

    /**
     * Get the message property: Descriptive message.
     *
     * @return the message value.
     */
    public String message() {
        return this.message;
    }

    /**
     * Set the message property: Descriptive message.
     *
     * @param message the message value to set.
     * @return the Status object itself.
     */
    public Status withMessage(String message) {
        this.message = message;
        return this;
    }

    /**
     * Get the statusId property: Level of the most severe insight generated by the detector.
     *
     * @return the statusId value.
     */
    public InsightStatus statusId() {
        return this.statusId;
    }

    /**
     * Set the statusId property: Level of the most severe insight generated by the detector.
     *
     * @param statusId the statusId value to set.
     * @return the Status object itself.
     */
    public Status withStatusId(InsightStatus statusId) {
        this.statusId = statusId;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
