// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appservice.models.CertificateOrderActionType;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

/** CertificateOrderAction resource specific properties. */
@Immutable
public final class CertificateOrderActionProperties {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(CertificateOrderActionProperties.class);

    /*
     * Action type.
     */
    @JsonProperty(value = "actionType", access = JsonProperty.Access.WRITE_ONLY)
    private CertificateOrderActionType actionType;

    /*
     * Time at which the certificate action was performed.
     */
    @JsonProperty(value = "createdAt", access = JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime createdAt;

    /**
     * Get the actionType property: Action type.
     *
     * @return the actionType value.
     */
    public CertificateOrderActionType actionType() {
        return this.actionType;
    }

    /**
     * Get the createdAt property: Time at which the certificate action was performed.
     *
     * @return the createdAt value.
     */
    public OffsetDateTime createdAt() {
        return this.createdAt;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
