// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Hybrid Connection limits contract. This is used to return the plan limits of Hybrid Connections. */
@Fluent
public final class HybridConnectionLimitsInner extends ProxyOnlyResource {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(HybridConnectionLimitsInner.class);

    /*
     * HybridConnectionLimits resource specific properties
     */
    @JsonProperty(value = "properties")
    private HybridConnectionLimitsProperties innerProperties;

    /**
     * Get the innerProperties property: HybridConnectionLimits resource specific properties.
     *
     * @return the innerProperties value.
     */
    private HybridConnectionLimitsProperties innerProperties() {
        return this.innerProperties;
    }

    /** {@inheritDoc} */
    @Override
    public HybridConnectionLimitsInner withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    /**
     * Get the current property: The current number of Hybrid Connections.
     *
     * @return the current value.
     */
    public Integer current() {
        return this.innerProperties() == null ? null : this.innerProperties().current();
    }

    /**
     * Get the maximum property: The maximum number of Hybrid Connections allowed.
     *
     * @return the maximum value.
     */
    public Integer maximum() {
        return this.innerProperties() == null ? null : this.innerProperties().maximum();
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
