// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Function key info. */
@Fluent
public final class KeyInfoInner {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(KeyInfoInner.class);

    /*
     * Key name
     */
    @JsonProperty(value = "name")
    private String name;

    /*
     * Key value
     */
    @JsonProperty(value = "value")
    private String value;

    /**
     * Get the name property: Key name.
     *
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Key name.
     *
     * @param name the name value to set.
     * @return the KeyInfoInner object itself.
     */
    public KeyInfoInner withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the value property: Key value.
     *
     * @return the value value.
     */
    public String value() {
        return this.value;
    }

    /**
     * Set the value property: Key value.
     *
     * @param value the value value to set.
     * @return the KeyInfoInner object itself.
     */
    public KeyInfoInner withValue(String value) {
        this.value = value;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
