// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appservice.models.PrivateLinkResource;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Wrapper for a collection of private link resources. */
@Fluent
public final class PrivateLinkResourcesWrapperInner {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(PrivateLinkResourcesWrapperInner.class);

    /*
     * The value property.
     */
    @JsonProperty(value = "value", required = true)
    private List<PrivateLinkResource> value;

    /**
     * Get the value property: The value property.
     *
     * @return the value value.
     */
    public List<PrivateLinkResource> value() {
        return this.value;
    }

    /**
     * Set the value property: The value property.
     *
     * @param value the value value to set.
     * @return the PrivateLinkResourcesWrapperInner object itself.
     */
    public PrivateLinkResourcesWrapperInner withValue(List<PrivateLinkResource> value) {
        this.value = value;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() == null) {
            throw logger
                .logExceptionAsError(
                    new IllegalArgumentException(
                        "Missing required property value in model PrivateLinkResourcesWrapperInner"));
        } else {
            value().forEach(e -> e.validate());
        }
    }
}
