// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appservice.models.ApplicationLogsConfig;
import com.azure.resourcemanager.appservice.models.EnabledConfig;
import com.azure.resourcemanager.appservice.models.HttpLogsConfig;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Configuration of App Service site logs. */
@Fluent
public final class SiteLogsConfigInner extends ProxyOnlyResource {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(SiteLogsConfigInner.class);

    /*
     * SiteLogsConfig resource specific properties
     */
    @JsonProperty(value = "properties")
    private SiteLogsConfigProperties innerProperties;

    /**
     * Get the innerProperties property: SiteLogsConfig resource specific properties.
     *
     * @return the innerProperties value.
     */
    private SiteLogsConfigProperties innerProperties() {
        return this.innerProperties;
    }

    /** {@inheritDoc} */
    @Override
    public SiteLogsConfigInner withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    /**
     * Get the applicationLogs property: Application logs configuration.
     *
     * @return the applicationLogs value.
     */
    public ApplicationLogsConfig applicationLogs() {
        return this.innerProperties() == null ? null : this.innerProperties().applicationLogs();
    }

    /**
     * Set the applicationLogs property: Application logs configuration.
     *
     * @param applicationLogs the applicationLogs value to set.
     * @return the SiteLogsConfigInner object itself.
     */
    public SiteLogsConfigInner withApplicationLogs(ApplicationLogsConfig applicationLogs) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteLogsConfigProperties();
        }
        this.innerProperties().withApplicationLogs(applicationLogs);
        return this;
    }

    /**
     * Get the httpLogs property: HTTP logs configuration.
     *
     * @return the httpLogs value.
     */
    public HttpLogsConfig httpLogs() {
        return this.innerProperties() == null ? null : this.innerProperties().httpLogs();
    }

    /**
     * Set the httpLogs property: HTTP logs configuration.
     *
     * @param httpLogs the httpLogs value to set.
     * @return the SiteLogsConfigInner object itself.
     */
    public SiteLogsConfigInner withHttpLogs(HttpLogsConfig httpLogs) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteLogsConfigProperties();
        }
        this.innerProperties().withHttpLogs(httpLogs);
        return this;
    }

    /**
     * Get the failedRequestsTracing property: Failed requests tracing configuration.
     *
     * @return the failedRequestsTracing value.
     */
    public EnabledConfig failedRequestsTracing() {
        return this.innerProperties() == null ? null : this.innerProperties().failedRequestsTracing();
    }

    /**
     * Set the failedRequestsTracing property: Failed requests tracing configuration.
     *
     * @param failedRequestsTracing the failedRequestsTracing value to set.
     * @return the SiteLogsConfigInner object itself.
     */
    public SiteLogsConfigInner withFailedRequestsTracing(EnabledConfig failedRequestsTracing) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteLogsConfigProperties();
        }
        this.innerProperties().withFailedRequestsTracing(failedRequestsTracing);
        return this;
    }

    /**
     * Get the detailedErrorMessages property: Detailed error messages configuration.
     *
     * @return the detailedErrorMessages value.
     */
    public EnabledConfig detailedErrorMessages() {
        return this.innerProperties() == null ? null : this.innerProperties().detailedErrorMessages();
    }

    /**
     * Set the detailedErrorMessages property: Detailed error messages configuration.
     *
     * @param detailedErrorMessages the detailedErrorMessages value to set.
     * @return the SiteLogsConfigInner object itself.
     */
    public SiteLogsConfigInner withDetailedErrorMessages(EnabledConfig detailedErrorMessages) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SiteLogsConfigProperties();
        }
        this.innerProperties().withDetailedErrorMessages(detailedErrorMessages);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
