// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The configuration settings of the storage of the tokens if a file system is used. */
@Fluent
public final class FileSystemTokenStore {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(FileSystemTokenStore.class);

    /*
     * The directory in which the tokens will be stored.
     */
    @JsonProperty(value = "directory")
    private String directory;

    /**
     * Get the directory property: The directory in which the tokens will be stored.
     *
     * @return the directory value.
     */
    public String directory() {
        return this.directory;
    }

    /**
     * Set the directory property: The directory in which the tokens will be stored.
     *
     * @param directory the directory value to set.
     * @return the FileSystemTokenStore object itself.
     */
    public FileSystemTokenStore withDirectory(String directory) {
        this.directory = directory;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
