/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appservice.models.ArmIdWrapper;
import com.azure.resourcemanager.appservice.models.PrivateLinkConnectionState;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class RemotePrivateEndpointConnectionProperties {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(RemotePrivateEndpointConnectionProperties.class);
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private String provisioningState;
    @JsonProperty(value="privateEndpoint")
    private ArmIdWrapper privateEndpoint;
    @JsonProperty(value="privateLinkServiceConnectionState")
    private PrivateLinkConnectionState privateLinkServiceConnectionState;
    @JsonProperty(value="ipAddresses")
    private List<String> ipAddresses;

    public String provisioningState() {
        return this.provisioningState;
    }

    public ArmIdWrapper privateEndpoint() {
        return this.privateEndpoint;
    }

    public RemotePrivateEndpointConnectionProperties withPrivateEndpoint(ArmIdWrapper privateEndpoint) {
        this.privateEndpoint = privateEndpoint;
        return this;
    }

    public PrivateLinkConnectionState privateLinkServiceConnectionState() {
        return this.privateLinkServiceConnectionState;
    }

    public RemotePrivateEndpointConnectionProperties withPrivateLinkServiceConnectionState(PrivateLinkConnectionState privateLinkServiceConnectionState) {
        this.privateLinkServiceConnectionState = privateLinkServiceConnectionState;
        return this;
    }

    public List<String> ipAddresses() {
        return this.ipAddresses;
    }

    public RemotePrivateEndpointConnectionProperties withIpAddresses(List<String> ipAddresses) {
        this.ipAddresses = ipAddresses;
        return this;
    }

    public void validate() {
        if (this.privateEndpoint() != null) {
            this.privateEndpoint().validate();
        }
        if (this.privateLinkServiceConnectionState() != null) {
            this.privateLinkServiceConnectionState().validate();
        }
    }
}

