/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.appservice.fluent.AppServiceCertificateOrdersClient;
import com.azure.resourcemanager.appservice.fluent.models.AppServiceCertificateOrderInner;
import com.azure.resourcemanager.appservice.fluent.models.AppServiceCertificatePatchResourceInner;
import com.azure.resourcemanager.appservice.fluent.models.AppServiceCertificateResourceInner;
import com.azure.resourcemanager.appservice.fluent.models.CertificateEmailInner;
import com.azure.resourcemanager.appservice.fluent.models.CertificateOrderActionInner;
import com.azure.resourcemanager.appservice.fluent.models.NameIdentifierInner;
import com.azure.resourcemanager.appservice.fluent.models.SiteSealInner;
import com.azure.resourcemanager.appservice.implementation.WebSiteManagementClientImpl;
import com.azure.resourcemanager.appservice.models.AppServiceCertificateCollection;
import com.azure.resourcemanager.appservice.models.AppServiceCertificateOrderCollection;
import com.azure.resourcemanager.appservice.models.AppServiceCertificateOrderPatchResource;
import com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException;
import com.azure.resourcemanager.appservice.models.ReissueCertificateOrderRequest;
import com.azure.resourcemanager.appservice.models.RenewCertificateOrderRequest;
import com.azure.resourcemanager.appservice.models.SiteSealRequest;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsDelete;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsGet;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsListing;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.util.List;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class AppServiceCertificateOrdersClientImpl
implements InnerSupportsGet<AppServiceCertificateOrderInner>,
InnerSupportsListing<AppServiceCertificateOrderInner>,
InnerSupportsDelete<Void>,
AppServiceCertificateOrdersClient {
    private final ClientLogger logger = new ClientLogger(AppServiceCertificateOrdersClientImpl.class);
    private final AppServiceCertificateOrdersService service;
    private final WebSiteManagementClientImpl client;

    AppServiceCertificateOrdersClientImpl(WebSiteManagementClientImpl client) {
        this.service = (AppServiceCertificateOrdersService)RestProxy.create(AppServiceCertificateOrdersService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<AppServiceCertificateOrderInner>> listSinglePageAsync() {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AppServiceCertificateOrderCollection)res.getValue()).value(), ((AppServiceCertificateOrderCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<AppServiceCertificateOrderInner>> listSinglePageAsync(Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AppServiceCertificateOrderCollection)res.getValue()).value(), ((AppServiceCertificateOrderCollection)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<AppServiceCertificateOrderInner> listAsync() {
        return new PagedFlux(() -> this.listSinglePageAsync(), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<AppServiceCertificateOrderInner> listAsync(Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<AppServiceCertificateOrderInner> list() {
        return new PagedIterable(this.listAsync());
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<AppServiceCertificateOrderInner> list(Context context) {
        return new PagedIterable(this.listAsync(context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> validatePurchaseInformationWithResponseAsync(AppServiceCertificateOrderInner appServiceCertificateOrder) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (appServiceCertificateOrder == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter appServiceCertificateOrder is required and cannot be null."));
        }
        appServiceCertificateOrder.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.validatePurchaseInformation(this.client.getEndpoint(), this.client.getSubscriptionId(), this.client.getApiVersion(), appServiceCertificateOrder, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> validatePurchaseInformationWithResponseAsync(AppServiceCertificateOrderInner appServiceCertificateOrder, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (appServiceCertificateOrder == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter appServiceCertificateOrder is required and cannot be null."));
        }
        appServiceCertificateOrder.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.validatePurchaseInformation(this.client.getEndpoint(), this.client.getSubscriptionId(), this.client.getApiVersion(), appServiceCertificateOrder, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> validatePurchaseInformationAsync(AppServiceCertificateOrderInner appServiceCertificateOrder) {
        return this.validatePurchaseInformationWithResponseAsync(appServiceCertificateOrder).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void validatePurchaseInformation(AppServiceCertificateOrderInner appServiceCertificateOrder) {
        this.validatePurchaseInformationAsync(appServiceCertificateOrder).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> validatePurchaseInformationWithResponse(AppServiceCertificateOrderInner appServiceCertificateOrder, Context context) {
        return (Response)this.validatePurchaseInformationWithResponseAsync(appServiceCertificateOrder, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<AppServiceCertificateOrderInner>> listByResourceGroupSinglePageAsync(String resourceGroupName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByResourceGroup(this.client.getEndpoint(), resourceGroupName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AppServiceCertificateOrderCollection)res.getValue()).value(), ((AppServiceCertificateOrderCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<AppServiceCertificateOrderInner>> listByResourceGroupSinglePageAsync(String resourceGroupName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByResourceGroup(this.client.getEndpoint(), resourceGroupName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AppServiceCertificateOrderCollection)res.getValue()).value(), ((AppServiceCertificateOrderCollection)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<AppServiceCertificateOrderInner> listByResourceGroupAsync(String resourceGroupName) {
        return new PagedFlux(() -> this.listByResourceGroupSinglePageAsync(resourceGroupName), nextLink -> this.listByResourceGroupNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<AppServiceCertificateOrderInner> listByResourceGroupAsync(String resourceGroupName, Context context) {
        return new PagedFlux(() -> this.listByResourceGroupSinglePageAsync(resourceGroupName, context), nextLink -> this.listByResourceGroupNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<AppServiceCertificateOrderInner> listByResourceGroup(String resourceGroupName) {
        return new PagedIterable(this.listByResourceGroupAsync(resourceGroupName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<AppServiceCertificateOrderInner> listByResourceGroup(String resourceGroupName, Context context) {
        return new PagedIterable(this.listByResourceGroupAsync(resourceGroupName, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AppServiceCertificateOrderInner>> getByResourceGroupWithResponseAsync(String resourceGroupName, String certificateOrderName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (certificateOrderName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter certificateOrderName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getByResourceGroup(this.client.getEndpoint(), resourceGroupName, certificateOrderName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<AppServiceCertificateOrderInner>> getByResourceGroupWithResponseAsync(String resourceGroupName, String certificateOrderName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (certificateOrderName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter certificateOrderName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getByResourceGroup(this.client.getEndpoint(), resourceGroupName, certificateOrderName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AppServiceCertificateOrderInner> getByResourceGroupAsync(String resourceGroupName, String certificateOrderName) {
        return this.getByResourceGroupWithResponseAsync(resourceGroupName, certificateOrderName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((AppServiceCertificateOrderInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AppServiceCertificateOrderInner getByResourceGroup(String resourceGroupName, String certificateOrderName) {
        return (AppServiceCertificateOrderInner)((Object)this.getByResourceGroupAsync(resourceGroupName, certificateOrderName).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AppServiceCertificateOrderInner> getByResourceGroupWithResponse(String resourceGroupName, String certificateOrderName, Context context) {
        return (Response)this.getByResourceGroupWithResponseAsync(resourceGroupName, certificateOrderName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String certificateOrderName, AppServiceCertificateOrderInner certificateDistinguishedName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (certificateOrderName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter certificateOrderName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (certificateDistinguishedName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter certificateDistinguishedName is required and cannot be null."));
        }
        certificateDistinguishedName.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, certificateOrderName, this.client.getSubscriptionId(), this.client.getApiVersion(), certificateDistinguishedName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String certificateOrderName, AppServiceCertificateOrderInner certificateDistinguishedName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (certificateOrderName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter certificateOrderName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (certificateDistinguishedName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter certificateDistinguishedName is required and cannot be null."));
        }
        certificateDistinguishedName.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, certificateOrderName, this.client.getSubscriptionId(), this.client.getApiVersion(), certificateDistinguishedName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PollerFlux<PollResult<AppServiceCertificateOrderInner>, AppServiceCertificateOrderInner> beginCreateOrUpdateAsync(String resourceGroupName, String certificateOrderName, AppServiceCertificateOrderInner certificateDistinguishedName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, certificateOrderName, certificateDistinguishedName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)AppServiceCertificateOrderInner.class), (Type)((Object)AppServiceCertificateOrderInner.class), Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PollerFlux<PollResult<AppServiceCertificateOrderInner>, AppServiceCertificateOrderInner> beginCreateOrUpdateAsync(String resourceGroupName, String certificateOrderName, AppServiceCertificateOrderInner certificateDistinguishedName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, certificateOrderName, certificateDistinguishedName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)AppServiceCertificateOrderInner.class), (Type)((Object)AppServiceCertificateOrderInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PollResult<AppServiceCertificateOrderInner>, AppServiceCertificateOrderInner> beginCreateOrUpdate(String resourceGroupName, String certificateOrderName, AppServiceCertificateOrderInner certificateDistinguishedName) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, certificateOrderName, certificateDistinguishedName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PollResult<AppServiceCertificateOrderInner>, AppServiceCertificateOrderInner> beginCreateOrUpdate(String resourceGroupName, String certificateOrderName, AppServiceCertificateOrderInner certificateDistinguishedName, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, certificateOrderName, certificateDistinguishedName, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AppServiceCertificateOrderInner> createOrUpdateAsync(String resourceGroupName, String certificateOrderName, AppServiceCertificateOrderInner certificateDistinguishedName) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, certificateOrderName, certificateDistinguishedName).last().flatMap(arg_0 -> ((WebSiteManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<AppServiceCertificateOrderInner> createOrUpdateAsync(String resourceGroupName, String certificateOrderName, AppServiceCertificateOrderInner certificateDistinguishedName, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, certificateOrderName, certificateDistinguishedName, context).last().flatMap(arg_0 -> ((WebSiteManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AppServiceCertificateOrderInner createOrUpdate(String resourceGroupName, String certificateOrderName, AppServiceCertificateOrderInner certificateDistinguishedName) {
        return (AppServiceCertificateOrderInner)((Object)this.createOrUpdateAsync(resourceGroupName, certificateOrderName, certificateDistinguishedName).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AppServiceCertificateOrderInner createOrUpdate(String resourceGroupName, String certificateOrderName, AppServiceCertificateOrderInner certificateDistinguishedName, Context context) {
        return (AppServiceCertificateOrderInner)((Object)this.createOrUpdateAsync(resourceGroupName, certificateOrderName, certificateDistinguishedName, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String certificateOrderName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (certificateOrderName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter certificateOrderName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), resourceGroupName, certificateOrderName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String certificateOrderName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (certificateOrderName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter certificateOrderName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), resourceGroupName, certificateOrderName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String certificateOrderName) {
        return this.deleteWithResponseAsync(resourceGroupName, certificateOrderName).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String certificateOrderName) {
        this.deleteAsync(resourceGroupName, certificateOrderName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String resourceGroupName, String certificateOrderName, Context context) {
        return (Response)this.deleteWithResponseAsync(resourceGroupName, certificateOrderName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AppServiceCertificateOrderInner>> updateWithResponseAsync(String resourceGroupName, String certificateOrderName, AppServiceCertificateOrderPatchResource certificateDistinguishedName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (certificateOrderName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter certificateOrderName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (certificateDistinguishedName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter certificateDistinguishedName is required and cannot be null."));
        }
        certificateDistinguishedName.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), resourceGroupName, certificateOrderName, this.client.getSubscriptionId(), this.client.getApiVersion(), certificateDistinguishedName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<AppServiceCertificateOrderInner>> updateWithResponseAsync(String resourceGroupName, String certificateOrderName, AppServiceCertificateOrderPatchResource certificateDistinguishedName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (certificateOrderName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter certificateOrderName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (certificateDistinguishedName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter certificateDistinguishedName is required and cannot be null."));
        }
        certificateDistinguishedName.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.update(this.client.getEndpoint(), resourceGroupName, certificateOrderName, this.client.getSubscriptionId(), this.client.getApiVersion(), certificateDistinguishedName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AppServiceCertificateOrderInner> updateAsync(String resourceGroupName, String certificateOrderName, AppServiceCertificateOrderPatchResource certificateDistinguishedName) {
        return this.updateWithResponseAsync(resourceGroupName, certificateOrderName, certificateDistinguishedName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((AppServiceCertificateOrderInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AppServiceCertificateOrderInner update(String resourceGroupName, String certificateOrderName, AppServiceCertificateOrderPatchResource certificateDistinguishedName) {
        return (AppServiceCertificateOrderInner)((Object)this.updateAsync(resourceGroupName, certificateOrderName, certificateDistinguishedName).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AppServiceCertificateOrderInner> updateWithResponse(String resourceGroupName, String certificateOrderName, AppServiceCertificateOrderPatchResource certificateDistinguishedName, Context context) {
        return (Response)this.updateWithResponseAsync(resourceGroupName, certificateOrderName, certificateDistinguishedName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<AppServiceCertificateResourceInner>> listCertificatesSinglePageAsync(String resourceGroupName, String certificateOrderName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (certificateOrderName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter certificateOrderName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listCertificates(this.client.getEndpoint(), resourceGroupName, certificateOrderName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AppServiceCertificateCollection)res.getValue()).value(), ((AppServiceCertificateCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<AppServiceCertificateResourceInner>> listCertificatesSinglePageAsync(String resourceGroupName, String certificateOrderName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (certificateOrderName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter certificateOrderName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listCertificates(this.client.getEndpoint(), resourceGroupName, certificateOrderName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AppServiceCertificateCollection)res.getValue()).value(), ((AppServiceCertificateCollection)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<AppServiceCertificateResourceInner> listCertificatesAsync(String resourceGroupName, String certificateOrderName) {
        return new PagedFlux(() -> this.listCertificatesSinglePageAsync(resourceGroupName, certificateOrderName), nextLink -> this.listCertificatesNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<AppServiceCertificateResourceInner> listCertificatesAsync(String resourceGroupName, String certificateOrderName, Context context) {
        return new PagedFlux(() -> this.listCertificatesSinglePageAsync(resourceGroupName, certificateOrderName, context), nextLink -> this.listCertificatesNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<AppServiceCertificateResourceInner> listCertificates(String resourceGroupName, String certificateOrderName) {
        return new PagedIterable(this.listCertificatesAsync(resourceGroupName, certificateOrderName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<AppServiceCertificateResourceInner> listCertificates(String resourceGroupName, String certificateOrderName, Context context) {
        return new PagedIterable(this.listCertificatesAsync(resourceGroupName, certificateOrderName, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AppServiceCertificateResourceInner>> getCertificateWithResponseAsync(String resourceGroupName, String certificateOrderName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (certificateOrderName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter certificateOrderName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getCertificate(this.client.getEndpoint(), resourceGroupName, certificateOrderName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<AppServiceCertificateResourceInner>> getCertificateWithResponseAsync(String resourceGroupName, String certificateOrderName, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (certificateOrderName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter certificateOrderName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getCertificate(this.client.getEndpoint(), resourceGroupName, certificateOrderName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AppServiceCertificateResourceInner> getCertificateAsync(String resourceGroupName, String certificateOrderName, String name) {
        return this.getCertificateWithResponseAsync(resourceGroupName, certificateOrderName, name).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((AppServiceCertificateResourceInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AppServiceCertificateResourceInner getCertificate(String resourceGroupName, String certificateOrderName, String name) {
        return (AppServiceCertificateResourceInner)((Object)this.getCertificateAsync(resourceGroupName, certificateOrderName, name).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AppServiceCertificateResourceInner> getCertificateWithResponse(String resourceGroupName, String certificateOrderName, String name, Context context) {
        return (Response)this.getCertificateWithResponseAsync(resourceGroupName, certificateOrderName, name, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createOrUpdateCertificateWithResponseAsync(String resourceGroupName, String certificateOrderName, String name, AppServiceCertificateResourceInner keyVaultCertificate) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (certificateOrderName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter certificateOrderName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (keyVaultCertificate == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter keyVaultCertificate is required and cannot be null."));
        }
        keyVaultCertificate.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdateCertificate(this.client.getEndpoint(), resourceGroupName, certificateOrderName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), keyVaultCertificate, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateCertificateWithResponseAsync(String resourceGroupName, String certificateOrderName, String name, AppServiceCertificateResourceInner keyVaultCertificate, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (certificateOrderName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter certificateOrderName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (keyVaultCertificate == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter keyVaultCertificate is required and cannot be null."));
        }
        keyVaultCertificate.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdateCertificate(this.client.getEndpoint(), resourceGroupName, certificateOrderName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), keyVaultCertificate, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PollerFlux<PollResult<AppServiceCertificateResourceInner>, AppServiceCertificateResourceInner> beginCreateOrUpdateCertificateAsync(String resourceGroupName, String certificateOrderName, String name, AppServiceCertificateResourceInner keyVaultCertificate) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateCertificateWithResponseAsync(resourceGroupName, certificateOrderName, name, keyVaultCertificate);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)AppServiceCertificateResourceInner.class), (Type)((Object)AppServiceCertificateResourceInner.class), Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PollerFlux<PollResult<AppServiceCertificateResourceInner>, AppServiceCertificateResourceInner> beginCreateOrUpdateCertificateAsync(String resourceGroupName, String certificateOrderName, String name, AppServiceCertificateResourceInner keyVaultCertificate, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateCertificateWithResponseAsync(resourceGroupName, certificateOrderName, name, keyVaultCertificate, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)AppServiceCertificateResourceInner.class), (Type)((Object)AppServiceCertificateResourceInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PollResult<AppServiceCertificateResourceInner>, AppServiceCertificateResourceInner> beginCreateOrUpdateCertificate(String resourceGroupName, String certificateOrderName, String name, AppServiceCertificateResourceInner keyVaultCertificate) {
        return this.beginCreateOrUpdateCertificateAsync(resourceGroupName, certificateOrderName, name, keyVaultCertificate).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PollResult<AppServiceCertificateResourceInner>, AppServiceCertificateResourceInner> beginCreateOrUpdateCertificate(String resourceGroupName, String certificateOrderName, String name, AppServiceCertificateResourceInner keyVaultCertificate, Context context) {
        return this.beginCreateOrUpdateCertificateAsync(resourceGroupName, certificateOrderName, name, keyVaultCertificate, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AppServiceCertificateResourceInner> createOrUpdateCertificateAsync(String resourceGroupName, String certificateOrderName, String name, AppServiceCertificateResourceInner keyVaultCertificate) {
        return this.beginCreateOrUpdateCertificateAsync(resourceGroupName, certificateOrderName, name, keyVaultCertificate).last().flatMap(arg_0 -> ((WebSiteManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<AppServiceCertificateResourceInner> createOrUpdateCertificateAsync(String resourceGroupName, String certificateOrderName, String name, AppServiceCertificateResourceInner keyVaultCertificate, Context context) {
        return this.beginCreateOrUpdateCertificateAsync(resourceGroupName, certificateOrderName, name, keyVaultCertificate, context).last().flatMap(arg_0 -> ((WebSiteManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AppServiceCertificateResourceInner createOrUpdateCertificate(String resourceGroupName, String certificateOrderName, String name, AppServiceCertificateResourceInner keyVaultCertificate) {
        return (AppServiceCertificateResourceInner)((Object)this.createOrUpdateCertificateAsync(resourceGroupName, certificateOrderName, name, keyVaultCertificate).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AppServiceCertificateResourceInner createOrUpdateCertificate(String resourceGroupName, String certificateOrderName, String name, AppServiceCertificateResourceInner keyVaultCertificate, Context context) {
        return (AppServiceCertificateResourceInner)((Object)this.createOrUpdateCertificateAsync(resourceGroupName, certificateOrderName, name, keyVaultCertificate, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteCertificateWithResponseAsync(String resourceGroupName, String certificateOrderName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (certificateOrderName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter certificateOrderName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteCertificate(this.client.getEndpoint(), resourceGroupName, certificateOrderName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteCertificateWithResponseAsync(String resourceGroupName, String certificateOrderName, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (certificateOrderName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter certificateOrderName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.deleteCertificate(this.client.getEndpoint(), resourceGroupName, certificateOrderName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteCertificateAsync(String resourceGroupName, String certificateOrderName, String name) {
        return this.deleteCertificateWithResponseAsync(resourceGroupName, certificateOrderName, name).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteCertificate(String resourceGroupName, String certificateOrderName, String name) {
        this.deleteCertificateAsync(resourceGroupName, certificateOrderName, name).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteCertificateWithResponse(String resourceGroupName, String certificateOrderName, String name, Context context) {
        return (Response)this.deleteCertificateWithResponseAsync(resourceGroupName, certificateOrderName, name, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AppServiceCertificateResourceInner>> updateCertificateWithResponseAsync(String resourceGroupName, String certificateOrderName, String name, AppServiceCertificatePatchResourceInner keyVaultCertificate) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (certificateOrderName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter certificateOrderName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (keyVaultCertificate == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter keyVaultCertificate is required and cannot be null."));
        }
        keyVaultCertificate.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateCertificate(this.client.getEndpoint(), resourceGroupName, certificateOrderName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), keyVaultCertificate, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<AppServiceCertificateResourceInner>> updateCertificateWithResponseAsync(String resourceGroupName, String certificateOrderName, String name, AppServiceCertificatePatchResourceInner keyVaultCertificate, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (certificateOrderName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter certificateOrderName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (keyVaultCertificate == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter keyVaultCertificate is required and cannot be null."));
        }
        keyVaultCertificate.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.updateCertificate(this.client.getEndpoint(), resourceGroupName, certificateOrderName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), keyVaultCertificate, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AppServiceCertificateResourceInner> updateCertificateAsync(String resourceGroupName, String certificateOrderName, String name, AppServiceCertificatePatchResourceInner keyVaultCertificate) {
        return this.updateCertificateWithResponseAsync(resourceGroupName, certificateOrderName, name, keyVaultCertificate).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((AppServiceCertificateResourceInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AppServiceCertificateResourceInner updateCertificate(String resourceGroupName, String certificateOrderName, String name, AppServiceCertificatePatchResourceInner keyVaultCertificate) {
        return (AppServiceCertificateResourceInner)((Object)this.updateCertificateAsync(resourceGroupName, certificateOrderName, name, keyVaultCertificate).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AppServiceCertificateResourceInner> updateCertificateWithResponse(String resourceGroupName, String certificateOrderName, String name, AppServiceCertificatePatchResourceInner keyVaultCertificate, Context context) {
        return (Response)this.updateCertificateWithResponseAsync(resourceGroupName, certificateOrderName, name, keyVaultCertificate, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> reissueWithResponseAsync(String resourceGroupName, String certificateOrderName, ReissueCertificateOrderRequest reissueCertificateOrderRequest) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (certificateOrderName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter certificateOrderName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (reissueCertificateOrderRequest == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter reissueCertificateOrderRequest is required and cannot be null."));
        }
        reissueCertificateOrderRequest.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.reissue(this.client.getEndpoint(), resourceGroupName, certificateOrderName, this.client.getSubscriptionId(), this.client.getApiVersion(), reissueCertificateOrderRequest, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> reissueWithResponseAsync(String resourceGroupName, String certificateOrderName, ReissueCertificateOrderRequest reissueCertificateOrderRequest, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (certificateOrderName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter certificateOrderName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (reissueCertificateOrderRequest == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter reissueCertificateOrderRequest is required and cannot be null."));
        }
        reissueCertificateOrderRequest.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.reissue(this.client.getEndpoint(), resourceGroupName, certificateOrderName, this.client.getSubscriptionId(), this.client.getApiVersion(), reissueCertificateOrderRequest, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> reissueAsync(String resourceGroupName, String certificateOrderName, ReissueCertificateOrderRequest reissueCertificateOrderRequest) {
        return this.reissueWithResponseAsync(resourceGroupName, certificateOrderName, reissueCertificateOrderRequest).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void reissue(String resourceGroupName, String certificateOrderName, ReissueCertificateOrderRequest reissueCertificateOrderRequest) {
        this.reissueAsync(resourceGroupName, certificateOrderName, reissueCertificateOrderRequest).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> reissueWithResponse(String resourceGroupName, String certificateOrderName, ReissueCertificateOrderRequest reissueCertificateOrderRequest, Context context) {
        return (Response)this.reissueWithResponseAsync(resourceGroupName, certificateOrderName, reissueCertificateOrderRequest, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> renewWithResponseAsync(String resourceGroupName, String certificateOrderName, RenewCertificateOrderRequest renewCertificateOrderRequest) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (certificateOrderName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter certificateOrderName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (renewCertificateOrderRequest == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter renewCertificateOrderRequest is required and cannot be null."));
        }
        renewCertificateOrderRequest.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.renew(this.client.getEndpoint(), resourceGroupName, certificateOrderName, this.client.getSubscriptionId(), this.client.getApiVersion(), renewCertificateOrderRequest, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> renewWithResponseAsync(String resourceGroupName, String certificateOrderName, RenewCertificateOrderRequest renewCertificateOrderRequest, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (certificateOrderName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter certificateOrderName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (renewCertificateOrderRequest == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter renewCertificateOrderRequest is required and cannot be null."));
        }
        renewCertificateOrderRequest.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.renew(this.client.getEndpoint(), resourceGroupName, certificateOrderName, this.client.getSubscriptionId(), this.client.getApiVersion(), renewCertificateOrderRequest, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> renewAsync(String resourceGroupName, String certificateOrderName, RenewCertificateOrderRequest renewCertificateOrderRequest) {
        return this.renewWithResponseAsync(resourceGroupName, certificateOrderName, renewCertificateOrderRequest).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void renew(String resourceGroupName, String certificateOrderName, RenewCertificateOrderRequest renewCertificateOrderRequest) {
        this.renewAsync(resourceGroupName, certificateOrderName, renewCertificateOrderRequest).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> renewWithResponse(String resourceGroupName, String certificateOrderName, RenewCertificateOrderRequest renewCertificateOrderRequest, Context context) {
        return (Response)this.renewWithResponseAsync(resourceGroupName, certificateOrderName, renewCertificateOrderRequest, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> resendEmailWithResponseAsync(String resourceGroupName, String certificateOrderName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (certificateOrderName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter certificateOrderName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.resendEmail(this.client.getEndpoint(), resourceGroupName, certificateOrderName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> resendEmailWithResponseAsync(String resourceGroupName, String certificateOrderName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (certificateOrderName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter certificateOrderName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.resendEmail(this.client.getEndpoint(), resourceGroupName, certificateOrderName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> resendEmailAsync(String resourceGroupName, String certificateOrderName) {
        return this.resendEmailWithResponseAsync(resourceGroupName, certificateOrderName).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void resendEmail(String resourceGroupName, String certificateOrderName) {
        this.resendEmailAsync(resourceGroupName, certificateOrderName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> resendEmailWithResponse(String resourceGroupName, String certificateOrderName, Context context) {
        return (Response)this.resendEmailWithResponseAsync(resourceGroupName, certificateOrderName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> resendRequestEmailsWithResponseAsync(String resourceGroupName, String certificateOrderName, NameIdentifierInner nameIdentifier) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (certificateOrderName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter certificateOrderName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (nameIdentifier == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nameIdentifier is required and cannot be null."));
        }
        nameIdentifier.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.resendRequestEmails(this.client.getEndpoint(), resourceGroupName, certificateOrderName, this.client.getSubscriptionId(), this.client.getApiVersion(), nameIdentifier, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> resendRequestEmailsWithResponseAsync(String resourceGroupName, String certificateOrderName, NameIdentifierInner nameIdentifier, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (certificateOrderName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter certificateOrderName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (nameIdentifier == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nameIdentifier is required and cannot be null."));
        }
        nameIdentifier.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.resendRequestEmails(this.client.getEndpoint(), resourceGroupName, certificateOrderName, this.client.getSubscriptionId(), this.client.getApiVersion(), nameIdentifier, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> resendRequestEmailsAsync(String resourceGroupName, String certificateOrderName, NameIdentifierInner nameIdentifier) {
        return this.resendRequestEmailsWithResponseAsync(resourceGroupName, certificateOrderName, nameIdentifier).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void resendRequestEmails(String resourceGroupName, String certificateOrderName, NameIdentifierInner nameIdentifier) {
        this.resendRequestEmailsAsync(resourceGroupName, certificateOrderName, nameIdentifier).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> resendRequestEmailsWithResponse(String resourceGroupName, String certificateOrderName, NameIdentifierInner nameIdentifier, Context context) {
        return (Response)this.resendRequestEmailsWithResponseAsync(resourceGroupName, certificateOrderName, nameIdentifier, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SiteSealInner>> retrieveSiteSealWithResponseAsync(String resourceGroupName, String certificateOrderName, SiteSealRequest siteSealRequest) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (certificateOrderName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter certificateOrderName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (siteSealRequest == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter siteSealRequest is required and cannot be null."));
        }
        siteSealRequest.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.retrieveSiteSeal(this.client.getEndpoint(), resourceGroupName, certificateOrderName, this.client.getSubscriptionId(), this.client.getApiVersion(), siteSealRequest, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SiteSealInner>> retrieveSiteSealWithResponseAsync(String resourceGroupName, String certificateOrderName, SiteSealRequest siteSealRequest, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (certificateOrderName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter certificateOrderName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (siteSealRequest == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter siteSealRequest is required and cannot be null."));
        }
        siteSealRequest.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.retrieveSiteSeal(this.client.getEndpoint(), resourceGroupName, certificateOrderName, this.client.getSubscriptionId(), this.client.getApiVersion(), siteSealRequest, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SiteSealInner> retrieveSiteSealAsync(String resourceGroupName, String certificateOrderName, SiteSealRequest siteSealRequest) {
        return this.retrieveSiteSealWithResponseAsync(resourceGroupName, certificateOrderName, siteSealRequest).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((SiteSealInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SiteSealInner retrieveSiteSeal(String resourceGroupName, String certificateOrderName, SiteSealRequest siteSealRequest) {
        return (SiteSealInner)this.retrieveSiteSealAsync(resourceGroupName, certificateOrderName, siteSealRequest).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SiteSealInner> retrieveSiteSealWithResponse(String resourceGroupName, String certificateOrderName, SiteSealRequest siteSealRequest, Context context) {
        return (Response)this.retrieveSiteSealWithResponseAsync(resourceGroupName, certificateOrderName, siteSealRequest, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> verifyDomainOwnershipWithResponseAsync(String resourceGroupName, String certificateOrderName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (certificateOrderName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter certificateOrderName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.verifyDomainOwnership(this.client.getEndpoint(), resourceGroupName, certificateOrderName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> verifyDomainOwnershipWithResponseAsync(String resourceGroupName, String certificateOrderName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (certificateOrderName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter certificateOrderName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.verifyDomainOwnership(this.client.getEndpoint(), resourceGroupName, certificateOrderName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> verifyDomainOwnershipAsync(String resourceGroupName, String certificateOrderName) {
        return this.verifyDomainOwnershipWithResponseAsync(resourceGroupName, certificateOrderName).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void verifyDomainOwnership(String resourceGroupName, String certificateOrderName) {
        this.verifyDomainOwnershipAsync(resourceGroupName, certificateOrderName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> verifyDomainOwnershipWithResponse(String resourceGroupName, String certificateOrderName, Context context) {
        return (Response)this.verifyDomainOwnershipWithResponseAsync(resourceGroupName, certificateOrderName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<List<CertificateOrderActionInner>>> retrieveCertificateActionsWithResponseAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.retrieveCertificateActions(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<List<CertificateOrderActionInner>>> retrieveCertificateActionsWithResponseAsync(String resourceGroupName, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.retrieveCertificateActions(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<List<CertificateOrderActionInner>> retrieveCertificateActionsAsync(String resourceGroupName, String name) {
        return this.retrieveCertificateActionsWithResponseAsync(resourceGroupName, name).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((List)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public List<CertificateOrderActionInner> retrieveCertificateActions(String resourceGroupName, String name) {
        return (List)this.retrieveCertificateActionsAsync(resourceGroupName, name).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<List<CertificateOrderActionInner>> retrieveCertificateActionsWithResponse(String resourceGroupName, String name, Context context) {
        return (Response)this.retrieveCertificateActionsWithResponseAsync(resourceGroupName, name, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<List<CertificateEmailInner>>> retrieveCertificateEmailHistoryWithResponseAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.retrieveCertificateEmailHistory(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<List<CertificateEmailInner>>> retrieveCertificateEmailHistoryWithResponseAsync(String resourceGroupName, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.retrieveCertificateEmailHistory(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<List<CertificateEmailInner>> retrieveCertificateEmailHistoryAsync(String resourceGroupName, String name) {
        return this.retrieveCertificateEmailHistoryWithResponseAsync(resourceGroupName, name).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((List)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public List<CertificateEmailInner> retrieveCertificateEmailHistory(String resourceGroupName, String name) {
        return (List)this.retrieveCertificateEmailHistoryAsync(resourceGroupName, name).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<List<CertificateEmailInner>> retrieveCertificateEmailHistoryWithResponse(String resourceGroupName, String name, Context context) {
        return (Response)this.retrieveCertificateEmailHistoryWithResponseAsync(resourceGroupName, name, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<AppServiceCertificateOrderInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AppServiceCertificateOrderCollection)res.getValue()).value(), ((AppServiceCertificateOrderCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<AppServiceCertificateOrderInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AppServiceCertificateOrderCollection)res.getValue()).value(), ((AppServiceCertificateOrderCollection)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<AppServiceCertificateOrderInner>> listByResourceGroupNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByResourceGroupNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AppServiceCertificateOrderCollection)res.getValue()).value(), ((AppServiceCertificateOrderCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<AppServiceCertificateOrderInner>> listByResourceGroupNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByResourceGroupNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AppServiceCertificateOrderCollection)res.getValue()).value(), ((AppServiceCertificateOrderCollection)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<AppServiceCertificateResourceInner>> listCertificatesNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listCertificatesNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AppServiceCertificateCollection)res.getValue()).value(), ((AppServiceCertificateCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<AppServiceCertificateResourceInner>> listCertificatesNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listCertificatesNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AppServiceCertificateCollection)res.getValue()).value(), ((AppServiceCertificateCollection)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="WebSiteManagementCli")
    private static interface AppServiceCertificateOrdersService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.CertificateRegistration/certificateOrders")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<AppServiceCertificateOrderCollection>> list(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/providers/Microsoft.CertificateRegistration/validateCertificateRegistrationInformation")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<Void>> validatePurchaseInformation(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") AppServiceCertificateOrderInner var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<AppServiceCertificateOrderCollection>> listByResourceGroup(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="subscriptionId") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<AppServiceCertificateOrderInner>> getByResourceGroup(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="certificateOrderName") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="certificateOrderName") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, @BodyParam(value="application/json") AppServiceCertificateOrderInner var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<Void>> delete(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="certificateOrderName") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<AppServiceCertificateOrderInner>> update(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="certificateOrderName") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, @BodyParam(value="application/json") AppServiceCertificateOrderPatchResource var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}/certificates")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<AppServiceCertificateCollection>> listCertificates(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="certificateOrderName") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}/certificates/{name}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<AppServiceCertificateResourceInner>> getCertificate(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="certificateOrderName") String var3, @PathParam(value="name") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}/certificates/{name}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdateCertificate(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="certificateOrderName") String var3, @PathParam(value="name") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") AppServiceCertificateResourceInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}/certificates/{name}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<Void>> deleteCertificate(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="certificateOrderName") String var3, @PathParam(value="name") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}/certificates/{name}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<AppServiceCertificateResourceInner>> updateCertificate(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="certificateOrderName") String var3, @PathParam(value="name") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") AppServiceCertificatePatchResourceInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}/reissue")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<Void>> reissue(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="certificateOrderName") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, @BodyParam(value="application/json") ReissueCertificateOrderRequest var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}/renew")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<Void>> renew(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="certificateOrderName") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, @BodyParam(value="application/json") RenewCertificateOrderRequest var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}/resendEmail")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<Void>> resendEmail(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="certificateOrderName") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}/resendRequestEmails")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<Void>> resendRequestEmails(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="certificateOrderName") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, @BodyParam(value="application/json") NameIdentifierInner var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}/retrieveSiteSeal")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<SiteSealInner>> retrieveSiteSeal(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="certificateOrderName") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, @BodyParam(value="application/json") SiteSealRequest var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}/verifyDomainOwnership")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<Void>> verifyDomainOwnership(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="certificateOrderName") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{name}/retrieveCertificateActions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<List<CertificateOrderActionInner>>> retrieveCertificateActions(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="name") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{name}/retrieveEmailHistory")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<List<CertificateEmailInner>>> retrieveCertificateEmailHistory(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="name") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<AppServiceCertificateOrderCollection>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<AppServiceCertificateOrderCollection>> listByResourceGroupNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<AppServiceCertificateCollection>> listCertificatesNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

