/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appservice.fluent.models.DetectorDefinition;
import com.azure.resourcemanager.appservice.models.DiagnosticMetricSet;
import com.azure.resourcemanager.appservice.models.NameValuePair;
import com.azure.resourcemanager.appservice.models.ResponseMetadata;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class AnalysisData {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(AnalysisData.class);
    @JsonProperty(value="source")
    private String source;
    @JsonProperty(value="detectorDefinition")
    private DetectorDefinition detectorDefinition;
    @JsonProperty(value="metrics")
    private List<DiagnosticMetricSet> metrics;
    @JsonProperty(value="data")
    private List<List<NameValuePair>> data;
    @JsonProperty(value="detectorMetaData")
    private ResponseMetadata detectorMetadata;

    public String source() {
        return this.source;
    }

    public AnalysisData withSource(String source) {
        this.source = source;
        return this;
    }

    public DetectorDefinition detectorDefinition() {
        return this.detectorDefinition;
    }

    public AnalysisData withDetectorDefinition(DetectorDefinition detectorDefinition) {
        this.detectorDefinition = detectorDefinition;
        return this;
    }

    public List<DiagnosticMetricSet> metrics() {
        return this.metrics;
    }

    public AnalysisData withMetrics(List<DiagnosticMetricSet> metrics) {
        this.metrics = metrics;
        return this;
    }

    public List<List<NameValuePair>> data() {
        return this.data;
    }

    public AnalysisData withData(List<List<NameValuePair>> data) {
        this.data = data;
        return this;
    }

    public ResponseMetadata detectorMetadata() {
        return this.detectorMetadata;
    }

    public AnalysisData withDetectorMetadata(ResponseMetadata detectorMetadata) {
        this.detectorMetadata = detectorMetadata;
        return this;
    }

    public void validate() {
        if (this.detectorDefinition() != null) {
            this.detectorDefinition().validate();
        }
        if (this.metrics() != null) {
            this.metrics().forEach(e -> e.validate());
        }
        if (this.data() != null) {
            this.data().forEach(e -> e.forEach(e1 -> e1.validate()));
        }
        if (this.detectorMetadata() != null) {
            this.detectorMetadata().validate();
        }
    }
}

