/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appservice.models.ContainerCpuStatistics;
import com.azure.resourcemanager.appservice.models.ContainerMemoryStatistics;
import com.azure.resourcemanager.appservice.models.ContainerNetworkInterfaceStatistics;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

public final class ContainerInfo {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(ContainerInfo.class);
    @JsonProperty(value="currentTimeStamp")
    private OffsetDateTime currentTimestamp;
    @JsonProperty(value="previousTimeStamp")
    private OffsetDateTime previousTimestamp;
    @JsonProperty(value="currentCpuStats")
    private ContainerCpuStatistics currentCpuStats;
    @JsonProperty(value="previousCpuStats")
    private ContainerCpuStatistics previousCpuStats;
    @JsonProperty(value="memoryStats")
    private ContainerMemoryStatistics memoryStats;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="eth0")
    private ContainerNetworkInterfaceStatistics eth0;

    public OffsetDateTime currentTimestamp() {
        return this.currentTimestamp;
    }

    public ContainerInfo withCurrentTimestamp(OffsetDateTime currentTimestamp) {
        this.currentTimestamp = currentTimestamp;
        return this;
    }

    public OffsetDateTime previousTimestamp() {
        return this.previousTimestamp;
    }

    public ContainerInfo withPreviousTimestamp(OffsetDateTime previousTimestamp) {
        this.previousTimestamp = previousTimestamp;
        return this;
    }

    public ContainerCpuStatistics currentCpuStats() {
        return this.currentCpuStats;
    }

    public ContainerInfo withCurrentCpuStats(ContainerCpuStatistics currentCpuStats) {
        this.currentCpuStats = currentCpuStats;
        return this;
    }

    public ContainerCpuStatistics previousCpuStats() {
        return this.previousCpuStats;
    }

    public ContainerInfo withPreviousCpuStats(ContainerCpuStatistics previousCpuStats) {
        this.previousCpuStats = previousCpuStats;
        return this;
    }

    public ContainerMemoryStatistics memoryStats() {
        return this.memoryStats;
    }

    public ContainerInfo withMemoryStats(ContainerMemoryStatistics memoryStats) {
        this.memoryStats = memoryStats;
        return this;
    }

    public String name() {
        return this.name;
    }

    public ContainerInfo withName(String name) {
        this.name = name;
        return this;
    }

    public String id() {
        return this.id;
    }

    public ContainerInfo withId(String id) {
        this.id = id;
        return this;
    }

    public ContainerNetworkInterfaceStatistics eth0() {
        return this.eth0;
    }

    public ContainerInfo withEth0(ContainerNetworkInterfaceStatistics eth0) {
        this.eth0 = eth0;
        return this;
    }

    public void validate() {
        if (this.currentCpuStats() != null) {
            this.currentCpuStats().validate();
        }
        if (this.previousCpuStats() != null) {
            this.previousCpuStats().validate();
        }
        if (this.memoryStats() != null) {
            this.memoryStats().validate();
        }
        if (this.eth0() != null) {
            this.eth0().validate();
        }
    }
}

