/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appservice.models.AppInsightsWebAppStackSettings;
import com.azure.resourcemanager.appservice.models.GitHubActionWebAppStackSettings;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

public final class WebAppRuntimeSettings {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(WebAppRuntimeSettings.class);
    @JsonProperty(value="runtimeVersion", access=JsonProperty.Access.WRITE_ONLY)
    private String runtimeVersion;
    @JsonProperty(value="remoteDebuggingSupported", access=JsonProperty.Access.WRITE_ONLY)
    private Boolean remoteDebuggingSupported;
    @JsonProperty(value="appInsightsSettings", access=JsonProperty.Access.WRITE_ONLY)
    private AppInsightsWebAppStackSettings appInsightsSettings;
    @JsonProperty(value="gitHubActionSettings", access=JsonProperty.Access.WRITE_ONLY)
    private GitHubActionWebAppStackSettings gitHubActionSettings;
    @JsonProperty(value="isPreview", access=JsonProperty.Access.WRITE_ONLY)
    private Boolean isPreview;
    @JsonProperty(value="isDeprecated", access=JsonProperty.Access.WRITE_ONLY)
    private Boolean isDeprecated;
    @JsonProperty(value="isHidden", access=JsonProperty.Access.WRITE_ONLY)
    private Boolean isHidden;
    @JsonProperty(value="endOfLifeDate", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime endOfLifeDate;
    @JsonProperty(value="isAutoUpdate", access=JsonProperty.Access.WRITE_ONLY)
    private Boolean isAutoUpdate;
    @JsonProperty(value="isEarlyAccess", access=JsonProperty.Access.WRITE_ONLY)
    private Boolean isEarlyAccess;

    public String runtimeVersion() {
        return this.runtimeVersion;
    }

    public Boolean remoteDebuggingSupported() {
        return this.remoteDebuggingSupported;
    }

    public AppInsightsWebAppStackSettings appInsightsSettings() {
        return this.appInsightsSettings;
    }

    public GitHubActionWebAppStackSettings gitHubActionSettings() {
        return this.gitHubActionSettings;
    }

    public Boolean isPreview() {
        return this.isPreview;
    }

    public Boolean isDeprecated() {
        return this.isDeprecated;
    }

    public Boolean isHidden() {
        return this.isHidden;
    }

    public OffsetDateTime endOfLifeDate() {
        return this.endOfLifeDate;
    }

    public Boolean isAutoUpdate() {
        return this.isAutoUpdate;
    }

    public Boolean isEarlyAccess() {
        return this.isEarlyAccess;
    }

    public void validate() {
        if (this.appInsightsSettings() != null) {
            this.appInsightsSettings().validate();
        }
        if (this.gitHubActionSettings() != null) {
            this.gitHubActionSettings().validate();
        }
    }
}

